/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.IOException;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.tokenize.TokenizerEvaluationMonitor;
import opennlp.tools.tokenize.TokenizerEvaluator;
import opennlp.tools.tokenize.TokenizerFactory;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.eval.CrossValidationPartitioner;
import opennlp.tools.util.eval.FMeasure;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenizerCrossValidator {
    private final TrainingParameters params;
    private FMeasure fmeasure = new FMeasure();
    private TokenizerEvaluationMonitor[] listeners;
    private final TokenizerFactory factory;

    public TokenizerCrossValidator(TrainingParameters params, TokenizerFactory factory, TokenizerEvaluationMonitor ... listeners) {
        this.params = params;
        this.listeners = listeners;
        this.factory = factory;
    }

    public TokenizerCrossValidator(String language, Dictionary abbreviations, boolean alphaNumericOptimization, TrainingParameters params, TokenizerEvaluationMonitor ... listeners) {
        this(params, new TokenizerFactory(language, abbreviations, alphaNumericOptimization, null), listeners);
    }

    public TokenizerCrossValidator(String language, boolean alphaNumericOptimization, int cutoff, int iterations) {
        this(language, alphaNumericOptimization, ModelUtil.createTrainingParameters(iterations, cutoff), new TokenizerEvaluationMonitor[0]);
    }

    public TokenizerCrossValidator(String language, boolean alphaNumericOptimization) {
        this(language, alphaNumericOptimization, ModelUtil.createTrainingParameters(100, 5), new TokenizerEvaluationMonitor[0]);
    }

    public TokenizerCrossValidator(String language, boolean alphaNumericOptimization, TrainingParameters params, TokenizerEvaluationMonitor ... listeners) {
        this(language, null, alphaNumericOptimization, params, listeners);
    }

    public void evaluate(ObjectStream<TokenSample> samples, int nFolds) throws IOException {
        CrossValidationPartitioner<TokenSample> partitioner = new CrossValidationPartitioner<TokenSample>(samples, nFolds);
        while (partitioner.hasNext()) {
            CrossValidationPartitioner.TrainingSampleStream<TokenSample> trainingSampleStream = partitioner.next();
            TokenizerModel model = TokenizerME.train(trainingSampleStream, this.factory, this.params);
            TokenizerEvaluator evaluator = new TokenizerEvaluator(new TokenizerME(model), this.listeners);
            evaluator.evaluate(trainingSampleStream.getTestSampleStream());
            this.fmeasure.mergeInto(evaluator.getFMeasure());
        }
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }
}

