% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openSTARS.R
\docType{package}
\name{openSTARS}
\alias{openSTARS}
\alias{openSTARS-package}
\title{openSTARS: An Open Source Implementation of the 'ArcGIS' Toolbox 'STARS'.}
\description{
openSTARS provides functions to prepare data so that it can be imported by
the \code{\link[SSN]{SSN}} package for spatial modelling on stream networks.
'GRASS GIS 7.0' (or greater) with installed addons r.stream.basins,
r.stream.distance, r.stream.order, and r.hydrodem is needed.
}
\examples{
\donttest{
# Initiate GRASS session
if(.Platform$OS.type == "windows"){
  gisbase = "c:/Program Files/GRASS GIS 7.4.0"
  } else {
  gisbase = "/usr/lib/grass74/"
  }
initGRASS(gisBase = gisbase,
    home = tempdir(),
    override = TRUE)

# Load files into GRASS
dem_path <- system.file("extdata", "nc", "elev_ned_30m.tif", package = "openSTARS")
sites_path <- system.file("extdata", "nc", "sites_nc.shp", package = "openSTARS")
preds_path <- c(system.file("extdata", "nc", "landuse.shp", package = "openSTARS"),
                system.file("extdata", "nc", "pointsources.shp", package = "openSTARS"))
setup_grass_environment(dem = dem_path)
import_data(dem = dem_path, sites = sites_path, predictor_vector = preds_path)
gmeta()

# Derive streams from DEM
derive_streams(burn = 0, accum_threshold = 700, condition = TRUE, clean = TRUE)

# Check and correct complex junctions (there are no complex juctions in this 
# example date set)
cj <- check_compl_junctions()
if(cj){
  correct_compl_junctions()
}

# calculate slope as potential predictor 
execGRASS("r.slope.aspect", flags = c("overwrite","quiet"),
parameters = list(
  elevation = "dem",
    slope = "slope"
    ))
    
# Prepare edges
calc_edges()
calc_attributes_edges(input_raster = "slope", stat_rast = "max", attr_name_rast = "maxSlo",
  input_vector = c("landuse", "pointsources"), stat_vect = c("percent", "count"), 
  attr_name_vect = c("landuse", "psource"))

# Prepare site
calc_sites()

# Usually, only one of the following methods is needed. The exact one takes
# much longer to run
# approximate potential predictor variables for each site based on edge values
calc_attributes_sites_approx(input_attr_name = c("maxSlo", "agri", "forest", "grass", "urban"), 
  output_attr_name = c("maxSloA", "agriA", "forestA", "grassA", "urbanA"),
  stat = c("max", rep("percent", 4)))

# exact potential predictor variables for each site based on catchments
calc_attributes_sites_exact(input_raster = "slope", attr_name_rast = "maxSloEx", stat_rast = "max",
  input_vector = "landuse", attr_name_vect = "landuse", stat_vect = "percent")

# Plot data
dem <- readRAST("dem", ignore.stderr = TRUE)
sites <- readVECT("sites", ignore.stderr = TRUE)
sites_orig <-  readVECT("sites_o", ignore.stderr = TRUE)
edges <- readVECT("edges", ignore.stderr = TRUE)
plot(dem, col = terrain.colors(20))
lines(edges, col = "blue")
points(sites_orig, pch = 4)
cols <- colorRampPalette(c("blue", "red"))(length(sites$H2OArea))[rank(sites$H2OArea)]
points(sites, pch = 16, col = cols)

# Write data to SSN Folder
ssn_dir <- file.path(tempdir(), "nc.ssn")
export_ssn(ssn_dir, delete_directory = TRUE)

# Check if all files are ok
library(SSN)
check_ssn(ssn_dir)

# Load into SSN-package
ssn_obj <- importSSN(ssn_dir, o.write = TRUE)
}
}
