% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oa_get.R
\name{oa_get}
\alias{oa_get}
\title{Get data from Openaddresses}
\usage{
oa_get(x, overwrite = FALSE, ...)
}
\arguments{
\item{x}{(character) URL for an openaddresses dataset, or an object of
class openadd}

\item{overwrite}{(logical) Will only overwrite existing path
if \code{TRUE}}

\item{...}{Pass on curl options to \code{\link[crul]{HttpClient}}}
}
\value{
a tibble (a data.frame), with attributes for original url and path
on disk
}
\description{
Get data from Openaddresses
}
\examples{
\dontrun{
(out1 <- oa_get("http://data.openaddresses.io/runs/142103/at/tirol.zip"))
(out2 <-
  oa_get("http://data.openaddresses.io/runs/142676/ca/bc/victoria.zip"))

# from a openadd class object
oa_get(as_openadd(country="us", state="nv", city="las_vegas"))

# combine data sets
(alldat <- oa_combine(out1, out2))

# Map data
if (!requireNamespace("leaflet")) {
  install.packages("leaflet")
}
library(leaflet)
small <- out2[[1]][1:5000,]
leaflet(small) \%>\%
  addTiles() \%>\%
  addCircles(lat = ~LAT, lng = ~LON,
             popup = unname(apply(small[, c('NUMBER', 'STREET')], 1,
             paste, collapse = " ")))
}
}
\references{
\url{https://openaddresses.io/}
}

