% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_fine_tune_model.R
\name{delete_fine_tune_model}
\alias{delete_fine_tune_model}
\title{Delete fine_tune model}
\usage{
delete_fine_tune_model(
  model,
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  openai_organization = NULL
)
}
\arguments{
\item{model}{required; a length one character vector.}

\item{openai_api_key}{required; defaults to \code{Sys.getenv("OPENAI_API_KEY")}
(i.e., the value is retrieved from the \code{.Renviron} file); a length one
character vector. Specifies OpenAI API key.}

\item{openai_organization}{optional; defaults to \code{NULL}; a length one
character vector. Specifies OpenAI organization.}
}
\value{
Returns a list, elements of which contains information about the
deleted model.
}
\description{
Deletes a fine-tuned model. See \href{https://platform.openai.com/docs/api-reference/fine-tunes/delete-model}{this page} for
details.
}
\details{
For arguments description please refer to the \href{https://platform.openai.com/docs/api-reference/fine-tunes/delete-model}{official documentation}.
}
\examples{
\dontrun{
fine_tunes <- list_fine_tunes()

fine_tunes <- fine_tunes$data

id <- fine_tunes[!is.na(fine_tunes[, "fine_tuned_model"]), "fine_tuned_model"]

delete_fine_tune_model(model = id[1])
}
}
\seealso{
Other fine-tune functions: 
\code{\link{cancel_fine_tune}()},
\code{\link{create_fine_tune}()},
\code{\link{list_fine_tune_events}()},
\code{\link{list_fine_tunes}()},
\code{\link{retrieve_fine_tune}()}
}
\concept{fine-tune functions}
