% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polar_pollroseMap.R
\name{pollroseMapStatic}
\alias{pollroseMapStatic}
\title{Percentile roses on a static ggmap}
\usage{
pollroseMapStatic(
  data,
  pollutant = NULL,
  statistic = "prop.count",
  breaks = NULL,
  facet = NULL,
  latitude = NULL,
  longitude = NULL,
  zoom = 13,
  ggmap = NULL,
  cols = "turbo",
  alpha = 1,
  key = FALSE,
  facet.nrow = NULL,
  d.icon = 150,
  d.fig = 3,
  ...
)
}
\arguments{
\item{data}{A data frame. The data frame must contain the data to plot the
directional analysis marker, which includes wind speed (\code{ws}), wind
direction (\code{wd}), and the column representing the concentration of a
pollutant. In addition, \code{data} must include a decimal latitude and
longitude.}

\item{pollutant}{The column name(s) of the pollutant(s) to plot. If multiple
pollutants are specified, they will each form part of a separate panel.}

\item{statistic}{The \code{statistic} to be applied to each data bin in the
plot. Options currently include "prop.count", "prop.mean" and
"abs.count". The default "prop.count" sizes bins according to
the proportion of the frequency of measurements.  Similarly,
"prop.mean" sizes bins according to their relative contribution to
the mean. "abs.count" provides the absolute count of measurements in
each bin.}

\item{breaks}{Most commonly, the number of break points. If not specified,
each marker will independently break its supplied data at approximately 6
sensible break points. When \code{breaks} are specified, all markers will
use the same break points. Breaks can also be used to set specific break
points. For example, the argument \code{breaks = c(0, 1, 10, 100)} breaks
the data into segments <1, 1-10, 10-100, >100.}

\item{facet}{Used for splitting the input data into different panels, passed
to the \code{type} argument of \code{\link[openair:cutData]{openair::cutData()}}. \code{facet} cannot be used if
multiple \code{pollutant} columns have been provided.}

\item{latitude, longitude}{The decimal latitude/longitude. If not provided,
will be automatically inferred from data by looking for a column named
"lat"/"latitude" or "lon"/"lng"/"long"/"longitude" (case-insensitively).}

\item{zoom}{The zoom level to use for the basemap, passed to
\code{\link[ggmap:get_stamenmap]{ggmap::get_stamenmap()}}. Alternatively, the \code{ggmap} argument can be used
for more precise control of the basemap.}

\item{ggmap}{By default, \code{openairmaps} will try to estimate an appropriate
bounding box for the input data and then run \code{\link[ggmap:get_stamenmap]{ggmap::get_stamenmap()}} to
import a basemap. The \code{ggmap} argument allows users to provide their own
\code{ggmap} object to override this, which allows for alternative bounding
boxes, map types and colours.}

\item{cols}{The colours used for plotting. See \code{\link[openair:openColours]{openair::openColours()}} for
more information.}

\item{alpha}{The alpha transparency to use for the plotting surface (a value
between 0 and 1 with zero being fully transparent and 1 fully opaque).}

\item{key}{Should a key for each marker be drawn? Default is \code{FALSE}.}

\item{facet.nrow}{Passed to the \code{nrow} argument of \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}.}

\item{d.icon}{The diameter of the plot on the map in pixels. This will affect
the size of the individual polar markers. Alternatively, a vector in the
form \code{c(width, height)} can be provided if a non-circular marker is
desired.}

\item{d.fig}{The diameter of the plots to be produced using \code{openair} in
inches. This will affect the resolution of the markers on the map.
Alternatively, a vector in the form \code{c(width, height)} can be provided if a
non-circular marker is desired.}

\item{...}{
  Arguments passed on to \code{\link[openair:pollutionRose]{openair::pollutionRose}}
  \describe{
    \item{\code{key.footer}}{Adds additional text/labels below the scale key. See
\code{key.header} for further information.}
    \item{\code{key.position}}{Location where the scale key is to plotted. Allowed
arguments currently include \dQuote{top}, \dQuote{right}, \dQuote{bottom}
and \dQuote{left}.}
    \item{\code{paddle}}{Either \code{TRUE} or \code{FALSE}. If \code{TRUE} plots rose
using 'paddle' style spokes. If \code{FALSE} plots rose using 'wedge' style
spokes.}
    \item{\code{seg}}{When \code{paddle = TRUE}, \code{seg} determines with width of the
segments. For example, \code{seg = 0.5} will produce segments 0.5 *
\code{angle}.}
    \item{\code{normalise}}{If \code{TRUE} each wind direction segment is normalised to
equal one. This is useful for showing how the concentrations (or other
parameters) contribute to each wind sector when the proportion of time the
wind is from that direction is low. A line showing the probability that the
wind directions is from a particular wind sector is also shown.}
  }}
}
\value{
a \code{ggplot2} plot with a \code{ggmap} basemap
}
\description{
\code{\link[=pollroseMapStatic]{pollroseMapStatic()}} creates a \code{ggplot2} map using percentile roses as
markers. As this function returns a \code{ggplot2} object, further customisation
can be achieved using functions like \code{\link[ggplot2:theme]{ggplot2::theme()}} and
\code{\link[ggplot2:guides]{ggplot2::guides()}}.
}
\section{Further customisation using ggplot2}{


As the outputs of the static directional analysis functions are \code{ggplot2}
figures, further customisation is possible using functions such as
\code{\link[ggplot2:theme]{ggplot2::theme()}}, \code{\link[ggplot2:guides]{ggplot2::guides()}} and \code{\link[ggplot2:labs]{ggplot2::labs()}}.

If multiple pollutants are specified, subscripting (e.g., the "x" in "NOx")
is achieved using the \link[ggtext:ggtext]{ggtext} package. Therefore if you
choose to override the plot theme, it is recommended to use
\verb{[ggplot2::theme()]} and \verb{[ggtext::element_markdown()]} to define the
\code{strip.text} parameter.

When arguments like \code{limits}, \code{percentile} or \code{breaks} are defined, a
legend is automatically added to the figure. Legends can be removed using
\code{ggplot2::theme(legend.position = "none")}, or further customised using
\code{\link[ggplot2:guides]{ggplot2::guides()}} and either \code{color = ggplot2::guide_colourbar()} for
continuous legends or \code{fill = ggplot2::guide_legend()} for discrete
legends.
}

\seealso{
the original \code{\link[openair:pollutionRose]{openair::pollutionRose()}}

\code{\link[=pollroseMap]{pollroseMap()}} for the interactive \code{leaflet} equivalent of
\code{\link[=pollroseMapStatic]{pollroseMapStatic()}}

Other static directional analysis maps: 
\code{\link{annulusMapStatic}()},
\code{\link{diffMapStatic}()},
\code{\link{freqMapStatic}()},
\code{\link{percentileMapStatic}()},
\code{\link{polarMapStatic}()},
\code{\link{windroseMapStatic}()}
}
\concept{static directional analysis maps}
