% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polar_windroseMap.R
\name{windroseMap}
\alias{windroseMap}
\title{Wind rose plots on interactive leaflet maps}
\usage{
windroseMap(
  data,
  ws.int = 2,
  breaks = 4,
  latitude = NULL,
  longitude = NULL,
  control = NULL,
  popup = NULL,
  label = NULL,
  provider = "OpenStreetMap",
  cols = "turbo",
  alpha = 1,
  key = FALSE,
  draw.legend = TRUE,
  collapse.control = FALSE,
  d.icon = 200,
  d.fig = 3.5,
  type = deprecated(),
  ...
)
}
\arguments{
\item{data}{A data frame. The data frame must contain the data to plot a
\code{\link[openair:windRose]{openair::windRose()}}, which includes wind speed (\code{ws}), and wind direction
(\code{wd}). In addition, \code{data} must include a decimal latitude and longitude.}

\item{ws.int}{The wind speed interval. Default is 2 m/s but for low met masts
with low mean wind speeds a value of 1 or 0.5 m/s may be better.}

\item{breaks}{Most commonly, the number of break points for wind speed in
windRose. For windRose and the ws.int default of 2 m/s, the default, 4,
generates the break points 2, 4, 6, 8 m/s. Breaks can also be used to set
specific break points. For example, the argument breaks = c(0, 1, 10, 100)
breaks the data into segments <1, 1-10, 10-100, >100.}

\item{latitude, longitude}{The decimal latitude/longitude. If not provided,
will be automatically inferred from data by looking for a column named
"lat"/"latitude" or "lon"/"lng"/"long"/"longitude" (case-insensitively).}

\item{control}{Used for splitting the input data into different groups which
can be selected between using a "layer control" interface, passed to the
\code{type} argument of \code{\link[openair:cutData]{openair::cutData()}}. \code{control} cannot be used if
multiple \code{pollutant} columns have been provided.}

\item{popup}{Columns to be used as the HTML content for marker popups. Popups
may be useful to show information about the individual sites (e.g., site
names, codes, types, etc.). If a vector of column names are provided they
are passed to \code{\link[=buildPopup]{buildPopup()}} using its default values.}

\item{label}{Column to be used as the HTML content for hover-over labels.
Labels are useful for the same reasons as popups, though are typically
shorter.}

\item{provider}{The base map(s) to be used. See
\url{http://leaflet-extras.github.io/leaflet-providers/preview/} for a list of
all base maps that can be used. If multiple base maps are provided, they
can be toggled between using a "layer control" interface. By default, the
interface will use the provider names as labels, but users can define their
own using a named vector (e.g., \code{c("Default" = "OpenStreetMap", "Satellite" = "Esri.WorldImagery")})}

\item{cols}{The colours used for plotting. See \code{\link[openair:openColours]{openair::openColours()}} for
more information.}

\item{alpha}{The alpha transparency to use for the plotting surface (a value
between 0 and 1 with zero being fully transparent and 1 fully opaque).}

\item{key}{Should a key for each marker be drawn? Default is \code{FALSE}.}

\item{draw.legend}{Should a shared legend be created at the side of the map?
Default is \code{TRUE}.}

\item{collapse.control}{Should the "layer control" interface be collapsed?
Defaults to \code{FALSE}.}

\item{d.icon}{The diameter of the plot on the map in pixels. This will affect
the size of the individual polar markers. Alternatively, a vector in the
form \code{c(width, height)} can be provided if a non-circular marker is
desired.}

\item{d.fig}{The diameter of the plots to be produced using \code{openair} in
inches. This will affect the resolution of the markers on the map.
Alternatively, a vector in the form \code{c(width, height)} can be provided if a
non-circular marker is desired.}

\item{type}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}. Different sites are now
automatically detected based on latitude and longitude. Please use \code{label}
and/or \code{popup} to label different sites.}

\item{...}{
  Arguments passed on to \code{\link[openair:windRose]{openair::windRose}}
  \describe{
    \item{\code{ws}}{Name of the column representing wind speed.}
    \item{\code{wd}}{Name of the column representing wind direction.}
    \item{\code{ws2,wd2}}{The user can supply a second set of wind speed and wind
direction values with which the first can be compared. See
\code{\link[openair:pollutionRose]{pollutionRose()}} for more details.}
    \item{\code{angle}}{Default angle of \dQuote{spokes} is 30. Other potentially useful
angles are 45 and 10. Note that the width of the wind speed interval may
need adjusting using \code{width}.}
    \item{\code{bias.corr}}{When \code{angle} does not divide exactly into 360 a bias is
introduced in the frequencies when the wind direction is already supplied
rounded to the nearest 10 degrees, as is often the case. For example, if
\code{angle = 22.5}, N, E, S, W will include 3 wind sectors and all other
angles will be two. A bias correction can made to correct for this problem.
A simple method according to Applequist (2012) is used to adjust the
frequencies.}
    \item{\code{grid.line}}{Grid line interval to use. If \code{NULL}, as in default,
this is assigned based on the available data range. However, it can also be
forced to a specific value, e.g. \code{grid.line = 10}. \code{grid.line}
can also be a list to control the interval, line type and colour. For
example \code{grid.line = list(value = 10, lty = 5, col = "purple")}.}
    \item{\code{width}}{For \code{paddle = TRUE}, the adjustment factor for width of
wind speed intervals. For example, \code{width = 1.5} will make the paddle
width 1.5 times wider.}
    \item{\code{seg}}{When \code{paddle = TRUE}, \code{seg} determines with width of the
segments. For example, \code{seg = 0.5} will produce segments 0.5 *
\code{angle}.}
    \item{\code{auto.text}}{Either \code{TRUE} (default) or \code{FALSE}. If \code{TRUE}
titles and axis labels will automatically try and format pollutant names
and units properly, e.g., by subscripting the \sQuote{2} in NO2.}
    \item{\code{offset}}{The size of the 'hole' in the middle of the plot, expressed as
a percentage of the polar axis scale, default 10.}
    \item{\code{normalise}}{If \code{TRUE} each wind direction segment is normalised to
equal one. This is useful for showing how the concentrations (or other
parameters) contribute to each wind sector when the proportion of time the
wind is from that direction is low. A line showing the probability that the
wind directions is from a particular wind sector is also shown.}
    \item{\code{max.freq}}{Controls the scaling used by setting the maximum value for
the radial limits. This is useful to ensure several plots use the same
radial limits.}
    \item{\code{paddle}}{Either \code{TRUE} or \code{FALSE}. If \code{TRUE} plots rose
using 'paddle' style spokes. If \code{FALSE} plots rose using 'wedge' style
spokes.}
    \item{\code{key.header}}{Adds additional text/labels above the scale key. For
example, passing \code{windRose(mydata, key.header = "ws")} adds the
addition text as a scale header. Note: This argument is passed to
\code{\link[openair:drawOpenKey]{drawOpenKey()}} via \code{\link[openair:quickText]{quickText()}}, applying the auto.text argument, to
handle formatting.}
    \item{\code{key.footer}}{Adds additional text/labels below the scale key. See
\code{key.header} for further information.}
    \item{\code{key.position}}{Location where the scale key is to plotted. Allowed
arguments currently include \dQuote{top}, \dQuote{right}, \dQuote{bottom}
and \dQuote{left}.}
    \item{\code{dig.lab}}{The number of significant figures at which scientific number
formatting is used in break point and key labelling. Default 5.}
    \item{\code{include.lowest}}{Logical. If \code{FALSE} (the default), the first
interval will be left exclusive and right inclusive. If \code{TRUE}, the
first interval will be left and right inclusive. Passed to the
\code{include.lowest} argument of \code{\link[=cut]{cut()}}.}
    \item{\code{statistic}}{The \code{statistic} to be applied to each data bin in the
plot. Options currently include \dQuote{prop.count}, \dQuote{prop.mean} and
\dQuote{abs.count}. The default \dQuote{prop.count} sizes bins according to
the proportion of the frequency of measurements.  Similarly,
\dQuote{prop.mean} sizes bins according to their relative contribution to
the mean. \dQuote{abs.count} provides the absolute count of measurements in
each bin.}
    \item{\code{pollutant}}{Alternative data series to be sampled instead of wind speed.
The \code{\link[openair:windRose]{windRose()}} default NULL is equivalent to \code{pollutant = "ws"}. Use
in \code{\link[openair:pollutionRose]{pollutionRose()}}.}
    \item{\code{angle.scale}}{The scale is by default shown at a 315 degree angle.
Sometimes the placement of the scale may interfere with an interesting
feature. The user can therefore set \code{angle.scale} to another value
(between 0 and 360 degrees) to mitigate such problems. For example
\code{angle.scale = 45} will draw the scale heading in a NE direction.}
    \item{\code{border}}{Border colour for shaded areas. Default is no border.}
  }}
}
\value{
A leaflet object.
}
\description{
\code{\link[=windroseMap]{windroseMap()}} creates a \code{leaflet} map using wind roses as markers. Multiple
layers of markers can be added and toggled between using \code{control}.
}
\examples{
\dontrun{
windroseMap(polar_data,
  provider = "Stamen.Toner"
)
}
}
\seealso{
the original \code{\link[openair:windRose]{openair::windRose()}}

\code{\link[=windroseMapStatic]{windroseMapStatic()}} for the static \code{ggmap} equivalent of
\code{\link[=windroseMap]{windroseMap()}}

Other interactive directional analysis maps: 
\code{\link{annulusMap}()},
\code{\link{diffMap}()},
\code{\link{freqMap}()},
\code{\link{percentileMap}()},
\code{\link{polarMap}()},
\code{\link{pollroseMap}()}
}
\concept{interactive directional analysis maps}
