% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oa2df.R
\name{authors2df}
\alias{authors2df}
\title{Convert OpenAlex collection of authors' records from list format to data frame}
\usage{
authors2df(data, verbose = TRUE)
}
\arguments{
\item{data}{List. Output of \code{oa_request}.}

\item{verbose}{Logical. If TRUE, print information on querying process.
Default to \code{verbose = FALSE}.}
}
\value{
a data.frame.

For more extensive information about OpenAlex API, please visit: <https://docs.openalex.org>
}
\description{
It converts bibliographic collection of authors' records gathered from OpenAlex database \href{https://openalex.org/}{https://openalex.org/} into data frame.
The function converts a list of authors' records obtained using \code{oa_request} into a data frame/tibble.
}
\examples{
\dontrun{

# Query to search information about all authors affiliated to the University of Naples Federico II
# which have authored at least 100 publications:

# University of Naples Federico II is associated to the OpenAlex id I71267560.


query_author <- oa_query(
  identifier = NULL,
  entity = "authors",
  last_known_institution.id = "I71267560",
  works_count = ">99"
)

res <- oa_request(
  query_url = query_author,
  count_only = FALSE,
  verbose = FALSE
)

df <- oa2df(res, entity = "authors")

df
}

# @export
}
