% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/areas.R
\name{opencv-area}
\alias{opencv-area}
\alias{ocv_rectangle}
\alias{ocv_polygon}
\alias{ocv_bbox}
\alias{ocv_chull}
\title{OpenCV area manipulation}
\usage{
ocv_rectangle(image, x = 0L, y = 0L, width, height)

ocv_polygon(image, pts, convex = FALSE, crop = FALSE, color = 255)

ocv_bbox(image, pts)

ocv_chull(pts)
}
\arguments{
\item{image}{an ocv image object}

\item{x}{horizontal location}

\item{y}{vertical location}

\item{width}{width of the area}

\item{height}{height of the area}

\item{pts}{a list of points with elements x and y}

\item{convex}{are the points convex}

\item{crop}{crop the resulting area to its bounding box}

\item{color}{color for the non-polygon area}
}
\description{
Manipulate image regions
}
\examples{
mona <- ocv_read('https://jeroen.github.io/images/monalisa.jpg')

# Rectangular area
ocv_rectangle(mona, x = 400, y = 300, height = 300, width = 350)
ocv_rectangle(mona, x = 0, y = 100, height = 200)
ocv_rectangle(mona, x = 500, y = 0, width = 75)

# Polygon area
img <- ocv_resize(mona, width = 320, height = 477)
pts <- list(x = c(184, 172, 146, 114,  90,  76,  92, 163, 258),
            y = c(72,   68,  70,  90, 110, 398, 412, 385, 210))
ocv_polygon(img, pts)
ocv_polygon(img, pts, crop = TRUE)
ocv_polygon(img, pts, convex = TRUE, crop = TRUE)

# Bounding box based on points
ocv_bbox(img, pts)

# Bounding box of non-zero pixel area
area <- ocv_polygon(img, pts, color = 0, crop = FALSE)
area
area <- ocv_bbox(area)
area

\dontshow{
ocv_destroy(mona)
ocv_destroy(img)
ocv_destroy(area)
}
}
