% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cert.R
\name{cert_verify}
\alias{ca_bundle}
\alias{cert_verify}
\alias{download_ssl_cert}
\title{X509 certificates}
\usage{
cert_verify(cert, root = ca_bundle())

download_ssl_cert(host = "localhost", port = 443)

ca_bundle()
}
\arguments{
\item{cert}{certficate (or certificate-chain) to be verified. Must be cert or list or path.}

\item{root}{trusted pubkey or certificate(s) e.g. CA bundle.}

\item{host}{string: hostname of the server to connect to}

\item{port}{integer: port to connect to}
}
\description{
Read, download, analyize and verify X.509 certificates.
}
\examples{
# Verify the r-project HTTPS cert
chain <- download_ssl_cert("www.r-project.org", 443)
print(chain)
print(as.list(chain[[1]])$pubkey)
cert_verify(chain, ca_bundle())

# Another example
chain <- download_ssl_cert("public.opencpu.org")
ocpu <- chain[[1]]
as.list(ocpu)$subject

# Write PEM format
write_pem(ocpu)
}
\seealso{
\link{read_cert}
}

