% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{protectWorksheet}
\alias{protectWorksheet}
\title{Protect a worksheet from modifications}
\usage{
protectWorksheet(wb, sheet, protect = TRUE, password = NULL,
  lockSelectingLockedCells = NULL, lockSelectingUnlockedCells = NULL,
  lockFormattingCells = NULL, lockFormattingColumns = NULL,
  lockFormattingRows = NULL, lockInsertingColumns = NULL,
  lockInsertingRows = NULL, lockInsertingHyperlinks = NULL,
  lockDeletingColumns = NULL, lockDeletingRows = NULL,
  lockSorting = NULL, lockAutoFilter = NULL, lockPivotTables = NULL,
  lockObjects = NULL, lockScenarios = NULL)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{protect}{Whether to protect or unprotect the sheet (default=TRUE)}

\item{password}{(optional) password required to unprotect the worksheet}

\item{lockSelectingLockedCells}{Whether selecting locked cells is locked}

\item{lockSelectingUnlockedCells}{Whether selecting unlocked cells is locked}

\item{lockFormattingCells}{Whether formatting cells is locked}

\item{lockFormattingColumns}{Whether formatting columns is locked}

\item{lockFormattingRows}{Whether formatting rows is locked}

\item{lockInsertingColumns}{Whether inserting columns is locked}

\item{lockInsertingRows}{Whether inserting rows is locked}

\item{lockInsertingHyperlinks}{Whether inserting hyperlinks is locked}

\item{lockDeletingColumns}{Whether deleting columns is locked}

\item{lockDeletingRows}{Whether deleting rows is locked}

\item{lockSorting}{Whether sorting is locked}

\item{lockAutoFilter}{Whether auto-filter is locked}

\item{lockPivotTables}{Whether pivot tables are locked}

\item{lockObjects}{Whether objects are locked}

\item{lockScenarios}{Whether scenarios are locked}
}
\description{
Protect or unprotect a worksheet from modifications by the user in the graphical user interface. Replaces an existing protection.
}
\examples{
wb <- createWorkbook()
addWorksheet(wb, "S1")
writeDataTable(wb, 1, x = iris[1:30,])
# Formatting cells / columns is allowed , but inserting / deleting columns is protected:
protectWorksheet(wb, "S1", protect = TRUE, 
                  lockFormattingCells = FALSE, lockFormattingColumns = FALSE, 
                  lockInsertingColumns = TRUE, lockDeletingColumns = TRUE)

# Remove the protection
protectWorksheet(wb, "S1", protect = FALSE)

\dontrun{
saveWorkbook(wb, "pageSetupExample.xlsx", overwrite = TRUE)
}
}
\author{
Reinhold Kainhofer
}
