% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{named_region}
\alias{named_region}
\alias{wb_add_named_region}
\alias{wb_remove_named_region}
\title{Create / delete a named region}
\usage{
wb_add_named_region(
  wb,
  sheet = current_sheet(),
  cols,
  rows,
  name,
  localSheetId = NULL,
  overwrite = FALSE
)

wb_remove_named_region(wb, sheet = current_sheet(), name = NULL)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{cols}{Numeric vector specifying columns to include in region}

\item{rows}{Numeric vector specifying rows to include in region}

\item{name}{Name for region. A character vector of length 1. Note region names musts be case-insensitive unique.}

\item{localSheetId}{localSheetId}

\item{overwrite}{Boolean. Overwrite if exists? Default to FALSE}
}
\description{
Create / delete a named region
}
\details{
Region is given by: min(cols):max(cols) X min(rows):max(rows)
}
\examples{
## create named regions
wb <- wb_workbook()
wb$add_worksheet("Sheet 1")

## specify region
wb$add_data(sheet = 1, x = iris, startCol = 1, startRow = 1)
wb$add_named_region(
  sheet = 1,
  name = "iris",
  rows = seq_len(nrow(iris) + 1),
  cols = seq_along(iris)
)


## using write_data 'name' argument
wb$add_data(sheet = 1, x = iris, name = "iris2", startCol = 10)

out_file <- temp_xlsx()
wb_save(wb, out_file, overwrite = TRUE)

## see named regions
get_named_regions(wb) ## From Workbook object
get_named_regions(out_file) ## From xlsx file

## delete one
wb$remove_named_region(name = "iris2")
get_named_regions(wb)

## read named regions
df <- read_xlsx(wb, namedRegion = "iris")
head(df)

df <- read_xlsx(out_file, namedRegion = "iris2")
head(df)
}
