% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write_data2}
\alias{write_data2}
\title{dummy function to write data}
\usage{
write_data2(
  wb,
  sheet,
  data,
  name = NULL,
  colNames = TRUE,
  rowNames = FALSE,
  startRow = 1,
  startCol = 1,
  removeCellStyle = FALSE,
  na.strings
)
}
\arguments{
\item{wb}{workbook}

\item{sheet}{sheet}

\item{data}{data to export}

\item{name}{If not NULL, a named region is defined.}

\item{colNames}{include colnames?}

\item{rowNames}{include rownames?}

\item{startRow}{row to place it}

\item{startCol}{col to place it}

\item{removeCellStyle}{keep the cell style?}

\item{na.strings}{optional na.strings argument. if missing #N/A is used. If NULL no cell value is written, if character or numeric this is written (even if NA is part of numeric data)}
}
\description{
dummy function to write data
}
\details{
The string \code{"_openxlsx_NA"} is reserved for \code{openxlsx2}. If the data frame
contains this string, the output will be broken.
}
\examples{
# create a workbook and add some sheets
wb <- wb_workbook()

wb$add_worksheet("sheet1")
write_data2(wb, "sheet1", mtcars, colNames = TRUE, rowNames = TRUE)

wb$add_worksheet("sheet2")
write_data2(wb, "sheet2", cars, colNames = FALSE)

wb$add_worksheet("sheet3")
write_data2(wb, "sheet3", letters)

wb$add_worksheet("sheet4")
write_data2(wb, "sheet4", as.data.frame(Titanic), startRow = 2, startCol = 2)

}
