% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook.R
\name{wbWorkbook}
\alias{wbWorkbook}
\title{Workbook class}
\description{
This is the class used by \code{openxlsx2} to modify workbooks from R.
You can load an existing workbook with \code{\link[=wb_load]{wb_load()}} and create a new one with
\code{\link[=wb_workbook]{wb_workbook()}}.

After that, you can modify the \code{wbWorkbook} object through two primary methods:

\emph{Wrapper Function Method}: Utilizes the \code{wb} family of functions that support
piping to streamline operations.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{wb <- wb_workbook(creator = "My name here") \%>\%
  wb_add_worksheet(sheet = "Expenditure", grid_lines = FALSE) \%>\%
  wb_add_data(x = USPersonalExpenditure, row_names = TRUE)
}\if{html}{\out{</div>}}

\emph{Chaining Method}: Directly modifies the object through a series of chained
function calls.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{wb <- wb_workbook(creator = "My name here")$
  add_worksheet(sheet = "Expenditure", grid_lines = FALSE)$
  add_data(x = USPersonalExpenditure, row_names = TRUE)
}\if{html}{\out{</div>}}

While wrapper functions require explicit assignment of their output to reflect
changes, chained functions inherently modify the input object. Both approaches
are equally supported, offering flexibility to suit user preferences. The
documentation mainly highlights the use of wrapper functions.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Import workbooks
path <- system.file("extdata/openxlsx2_example.xlsx", package = "openxlsx2")
wb <- wb_load(path)

## or create one yourself
wb <- wb_workbook()
# add a worksheet
wb$add_worksheet("sheet")
# add some data
wb$add_data("sheet", cars)
# Add data with piping in a different location
wb <- wb \%>\% wb_add_data(x = cars, dims = wb_dims(from_dims = "D4"))
# open it in your default spreadsheet software
if (interactive()) wb$open()
}\if{html}{\out{</div>}}

Note that the documentation is more complete in each of the wrapper functions.
(i.e. \code{?wb_add_data} rather than \code{?wbWorkbook}).
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{sheet_names}}{The names of the sheets}

\item{\code{calcChain}}{calcChain}

\item{\code{charts}}{charts}

\item{\code{is_chartsheet}}{A logical vector identifying if a sheet is a chartsheet.}

\item{\code{customXml}}{customXml}

\item{\code{connections}}{connections}

\item{\code{ctrlProps}}{ctrlProps}

\item{\code{Content_Types}}{Content_Types}

\item{\code{app}}{app}

\item{\code{core}}{The XML core}

\item{\code{custom}}{custom}

\item{\code{drawings}}{drawings}

\item{\code{drawings_rels}}{drawings_rels}

\item{\code{docMetadata}}{doc_meta_data}

\item{\code{activeX}}{activeX}

\item{\code{embeddings}}{embeddings}

\item{\code{externalLinks}}{externalLinks}

\item{\code{externalLinksRels}}{externalLinksRels}

\item{\code{featurePropertyBag}}{featurePropertyBag}

\item{\code{headFoot}}{The header and footer}

\item{\code{media}}{media}

\item{\code{metadata}}{contains cell/value metadata imported on load from xl/metadata.xml}

\item{\code{persons}}{Persons of the workbook. to be used with \code{\link[=wb_add_thread]{wb_add_thread()}}}

\item{\code{pivotTables}}{pivotTables}

\item{\code{pivotTables.xml.rels}}{pivotTables.xml.rels}

\item{\code{pivotDefinitions}}{pivotDefinitions}

\item{\code{pivotRecords}}{pivotRecords}

\item{\code{pivotDefinitionsRels}}{pivotDefinitionsRels}

\item{\code{queryTables}}{queryTables}

\item{\code{richData}}{richData}

\item{\code{slicers}}{slicers}

\item{\code{slicerCaches}}{slicerCaches}

\item{\code{sharedStrings}}{sharedStrings}

\item{\code{styles_mgr}}{styles_mgr}

\item{\code{tables}}{tables}

\item{\code{tables.xml.rels}}{tables.xml.rels}

\item{\code{theme}}{theme}

\item{\code{vbaProject}}{vbaProject}

\item{\code{vml}}{vml}

\item{\code{vml_rels}}{vml_rels}

\item{\code{comments}}{Comments (notes) present in the workbook.}

\item{\code{threadComments}}{Threaded comments}

\item{\code{timelines}}{timelines}

\item{\code{timelineCaches}}{timelineCaches}

\item{\code{workbook}}{workbook}

\item{\code{workbook.xml.rels}}{workbook.xml.rels}

\item{\code{worksheets}}{worksheets}

\item{\code{worksheets_rels}}{worksheets_rels}

\item{\code{sheetOrder}}{The sheet order.  Controls ordering for worksheets and
worksheet names.}

\item{\code{path}}{path}

\item{\code{namedSheetViews}}{namedSheetViews}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-wbWorkbook-new}{\code{wbWorkbook$new()}}
\item \href{#method-wbWorkbook-append}{\code{wbWorkbook$append()}}
\item \href{#method-wbWorkbook-append_sheets}{\code{wbWorkbook$append_sheets()}}
\item \href{#method-wbWorkbook-validate_sheet}{\code{wbWorkbook$validate_sheet()}}
\item \href{#method-wbWorkbook-add_chartsheet}{\code{wbWorkbook$add_chartsheet()}}
\item \href{#method-wbWorkbook-add_worksheet}{\code{wbWorkbook$add_worksheet()}}
\item \href{#method-wbWorkbook-clone_worksheet}{\code{wbWorkbook$clone_worksheet()}}
\item \href{#method-wbWorkbook-add_data}{\code{wbWorkbook$add_data()}}
\item \href{#method-wbWorkbook-add_data_table}{\code{wbWorkbook$add_data_table()}}
\item \href{#method-wbWorkbook-add_pivot_table}{\code{wbWorkbook$add_pivot_table()}}
\item \href{#method-wbWorkbook-add_slicer}{\code{wbWorkbook$add_slicer()}}
\item \href{#method-wbWorkbook-remove_slicer}{\code{wbWorkbook$remove_slicer()}}
\item \href{#method-wbWorkbook-add_timeline}{\code{wbWorkbook$add_timeline()}}
\item \href{#method-wbWorkbook-remove_timeline}{\code{wbWorkbook$remove_timeline()}}
\item \href{#method-wbWorkbook-add_formula}{\code{wbWorkbook$add_formula()}}
\item \href{#method-wbWorkbook-add_hyperlink}{\code{wbWorkbook$add_hyperlink()}}
\item \href{#method-wbWorkbook-remove_hyperlink}{\code{wbWorkbook$remove_hyperlink()}}
\item \href{#method-wbWorkbook-add_style}{\code{wbWorkbook$add_style()}}
\item \href{#method-wbWorkbook-to_df}{\code{wbWorkbook$to_df()}}
\item \href{#method-wbWorkbook-load}{\code{wbWorkbook$load()}}
\item \href{#method-wbWorkbook-save}{\code{wbWorkbook$save()}}
\item \href{#method-wbWorkbook-open}{\code{wbWorkbook$open()}}
\item \href{#method-wbWorkbook-buildTable}{\code{wbWorkbook$buildTable()}}
\item \href{#method-wbWorkbook-update_table}{\code{wbWorkbook$update_table()}}
\item \href{#method-wbWorkbook-copy_cells}{\code{wbWorkbook$copy_cells()}}
\item \href{#method-wbWorkbook-get_base_font}{\code{wbWorkbook$get_base_font()}}
\item \href{#method-wbWorkbook-set_base_font}{\code{wbWorkbook$set_base_font()}}
\item \href{#method-wbWorkbook-get_base_colors}{\code{wbWorkbook$get_base_colors()}}
\item \href{#method-wbWorkbook-get_base_colours}{\code{wbWorkbook$get_base_colours()}}
\item \href{#method-wbWorkbook-set_base_colors}{\code{wbWorkbook$set_base_colors()}}
\item \href{#method-wbWorkbook-set_base_colours}{\code{wbWorkbook$set_base_colours()}}
\item \href{#method-wbWorkbook-get_bookview}{\code{wbWorkbook$get_bookview()}}
\item \href{#method-wbWorkbook-remove_bookview}{\code{wbWorkbook$remove_bookview()}}
\item \href{#method-wbWorkbook-set_bookview}{\code{wbWorkbook$set_bookview()}}
\item \href{#method-wbWorkbook-get_sheet_names}{\code{wbWorkbook$get_sheet_names()}}
\item \href{#method-wbWorkbook-set_sheet_names}{\code{wbWorkbook$set_sheet_names()}}
\item \href{#method-wbWorkbook-set_row_heights}{\code{wbWorkbook$set_row_heights()}}
\item \href{#method-wbWorkbook-remove_row_heights}{\code{wbWorkbook$remove_row_heights()}}
\item \href{#method-wbWorkbook-createCols}{\code{wbWorkbook$createCols()}}
\item \href{#method-wbWorkbook-group_cols}{\code{wbWorkbook$group_cols()}}
\item \href{#method-wbWorkbook-ungroup_cols}{\code{wbWorkbook$ungroup_cols()}}
\item \href{#method-wbWorkbook-remove_col_widths}{\code{wbWorkbook$remove_col_widths()}}
\item \href{#method-wbWorkbook-set_col_widths}{\code{wbWorkbook$set_col_widths()}}
\item \href{#method-wbWorkbook-group_rows}{\code{wbWorkbook$group_rows()}}
\item \href{#method-wbWorkbook-ungroup_rows}{\code{wbWorkbook$ungroup_rows()}}
\item \href{#method-wbWorkbook-remove_worksheet}{\code{wbWorkbook$remove_worksheet()}}
\item \href{#method-wbWorkbook-add_data_validation}{\code{wbWorkbook$add_data_validation()}}
\item \href{#method-wbWorkbook-merge_cells}{\code{wbWorkbook$merge_cells()}}
\item \href{#method-wbWorkbook-unmerge_cells}{\code{wbWorkbook$unmerge_cells()}}
\item \href{#method-wbWorkbook-freeze_pane}{\code{wbWorkbook$freeze_pane()}}
\item \href{#method-wbWorkbook-add_comment}{\code{wbWorkbook$add_comment()}}
\item \href{#method-wbWorkbook-get_comment}{\code{wbWorkbook$get_comment()}}
\item \href{#method-wbWorkbook-remove_comment}{\code{wbWorkbook$remove_comment()}}
\item \href{#method-wbWorkbook-add_thread}{\code{wbWorkbook$add_thread()}}
\item \href{#method-wbWorkbook-get_thread}{\code{wbWorkbook$get_thread()}}
\item \href{#method-wbWorkbook-add_conditional_formatting}{\code{wbWorkbook$add_conditional_formatting()}}
\item \href{#method-wbWorkbook-remove_conditional_formatting}{\code{wbWorkbook$remove_conditional_formatting()}}
\item \href{#method-wbWorkbook-add_image}{\code{wbWorkbook$add_image()}}
\item \href{#method-wbWorkbook-add_plot}{\code{wbWorkbook$add_plot()}}
\item \href{#method-wbWorkbook-add_drawing}{\code{wbWorkbook$add_drawing()}}
\item \href{#method-wbWorkbook-add_chart_xml}{\code{wbWorkbook$add_chart_xml()}}
\item \href{#method-wbWorkbook-add_mschart}{\code{wbWorkbook$add_mschart()}}
\item \href{#method-wbWorkbook-add_form_control}{\code{wbWorkbook$add_form_control()}}
\item \href{#method-wbWorkbook-print}{\code{wbWorkbook$print()}}
\item \href{#method-wbWorkbook-protect}{\code{wbWorkbook$protect()}}
\item \href{#method-wbWorkbook-protect_worksheet}{\code{wbWorkbook$protect_worksheet()}}
\item \href{#method-wbWorkbook-get_properties}{\code{wbWorkbook$get_properties()}}
\item \href{#method-wbWorkbook-set_properties}{\code{wbWorkbook$set_properties()}}
\item \href{#method-wbWorkbook-add_mips}{\code{wbWorkbook$add_mips()}}
\item \href{#method-wbWorkbook-get_mips}{\code{wbWorkbook$get_mips()}}
\item \href{#method-wbWorkbook-set_creators}{\code{wbWorkbook$set_creators()}}
\item \href{#method-wbWorkbook-add_creators}{\code{wbWorkbook$add_creators()}}
\item \href{#method-wbWorkbook-remove_creators}{\code{wbWorkbook$remove_creators()}}
\item \href{#method-wbWorkbook-set_last_modified_by}{\code{wbWorkbook$set_last_modified_by()}}
\item \href{#method-wbWorkbook-set_page_setup}{\code{wbWorkbook$set_page_setup()}}
\item \href{#method-wbWorkbook-page_setup}{\code{wbWorkbook$page_setup()}}
\item \href{#method-wbWorkbook-set_header_footer}{\code{wbWorkbook$set_header_footer()}}
\item \href{#method-wbWorkbook-get_tables}{\code{wbWorkbook$get_tables()}}
\item \href{#method-wbWorkbook-remove_tables}{\code{wbWorkbook$remove_tables()}}
\item \href{#method-wbWorkbook-add_filter}{\code{wbWorkbook$add_filter()}}
\item \href{#method-wbWorkbook-remove_filter}{\code{wbWorkbook$remove_filter()}}
\item \href{#method-wbWorkbook-set_grid_lines}{\code{wbWorkbook$set_grid_lines()}}
\item \href{#method-wbWorkbook-grid_lines}{\code{wbWorkbook$grid_lines()}}
\item \href{#method-wbWorkbook-add_named_region}{\code{wbWorkbook$add_named_region()}}
\item \href{#method-wbWorkbook-get_named_regions}{\code{wbWorkbook$get_named_regions()}}
\item \href{#method-wbWorkbook-remove_named_region}{\code{wbWorkbook$remove_named_region()}}
\item \href{#method-wbWorkbook-set_order}{\code{wbWorkbook$set_order()}}
\item \href{#method-wbWorkbook-get_sheet_visibility}{\code{wbWorkbook$get_sheet_visibility()}}
\item \href{#method-wbWorkbook-set_sheet_visibility}{\code{wbWorkbook$set_sheet_visibility()}}
\item \href{#method-wbWorkbook-add_page_break}{\code{wbWorkbook$add_page_break()}}
\item \href{#method-wbWorkbook-clean_sheet}{\code{wbWorkbook$clean_sheet()}}
\item \href{#method-wbWorkbook-add_border}{\code{wbWorkbook$add_border()}}
\item \href{#method-wbWorkbook-add_fill}{\code{wbWorkbook$add_fill()}}
\item \href{#method-wbWorkbook-add_font}{\code{wbWorkbook$add_font()}}
\item \href{#method-wbWorkbook-add_numfmt}{\code{wbWorkbook$add_numfmt()}}
\item \href{#method-wbWorkbook-add_cell_style}{\code{wbWorkbook$add_cell_style()}}
\item \href{#method-wbWorkbook-get_cell_style}{\code{wbWorkbook$get_cell_style()}}
\item \href{#method-wbWorkbook-set_cell_style}{\code{wbWorkbook$set_cell_style()}}
\item \href{#method-wbWorkbook-set_cell_style_across}{\code{wbWorkbook$set_cell_style_across()}}
\item \href{#method-wbWorkbook-add_named_style}{\code{wbWorkbook$add_named_style()}}
\item \href{#method-wbWorkbook-add_dxfs_style}{\code{wbWorkbook$add_dxfs_style()}}
\item \href{#method-wbWorkbook-clone_sheet_style}{\code{wbWorkbook$clone_sheet_style()}}
\item \href{#method-wbWorkbook-add_sparklines}{\code{wbWorkbook$add_sparklines()}}
\item \href{#method-wbWorkbook-add_ignore_error}{\code{wbWorkbook$add_ignore_error()}}
\item \href{#method-wbWorkbook-set_sheetview}{\code{wbWorkbook$set_sheetview()}}
\item \href{#method-wbWorkbook-add_person}{\code{wbWorkbook$add_person()}}
\item \href{#method-wbWorkbook-get_person}{\code{wbWorkbook$get_person()}}
\item \href{#method-wbWorkbook-get_active_sheet}{\code{wbWorkbook$get_active_sheet()}}
\item \href{#method-wbWorkbook-set_active_sheet}{\code{wbWorkbook$set_active_sheet()}}
\item \href{#method-wbWorkbook-get_selected}{\code{wbWorkbook$get_selected()}}
\item \href{#method-wbWorkbook-set_selected}{\code{wbWorkbook$set_selected()}}
\item \href{#method-wbWorkbook-clone}{\code{wbWorkbook$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-new"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-new}{}}}
\subsection{Method \code{new()}}{
Creates a new \code{wbWorkbook} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$new(
  creator = NULL,
  title = NULL,
  subject = NULL,
  category = NULL,
  datetime_created = Sys.time(),
  datetime_modified = NULL,
  theme = NULL,
  keywords = NULL,
  comments = NULL,
  manager = NULL,
  company = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{creator}}{character vector of creators. Duplicated are ignored.}

\item{\code{title, subject, category, keywords, comments, manager, company}}{workbook properties}

\item{\code{datetime_created}}{The datetime (as \code{POSIXt}) the workbook is
created.  Defaults to the current \code{Sys.time()} when the workbook object
is created, not when the Excel files are saved.}

\item{\code{datetime_modified}}{The datetime (as \code{POSIXt}) that should be recorded
as last modification date. Defaults to the creation date.}

\item{\code{theme}}{Optional theme identified by string or number}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-append"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-append}{}}}
\subsection{Method \code{append()}}{
Append a field. This method is intended for internal use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$append(field, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{A valid field name}

\item{\code{value}}{A value for the field}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-append_sheets"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-append_sheets}{}}}
\subsection{Method \code{append_sheets()}}{
Append to \code{self$workbook$sheets} This method is intended for internal use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$append_sheets(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A value for \code{self$workbook$sheets}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-validate_sheet"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-validate_sheet}{}}}
\subsection{Method \code{validate_sheet()}}{
validate sheet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$validate_sheet(sheet)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{A character sheet name or integer location}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The integer position of the sheet
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_chartsheet"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_chartsheet}{}}}
\subsection{Method \code{add_chartsheet()}}{
Add a chart sheet to the workbook
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_chartsheet(
  sheet = next_sheet(),
  tab_color = NULL,
  zoom = 100,
  visible = c("true", "false", "hidden", "visible", "veryhidden"),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{tab_color}}{tab_color}

\item{\code{zoom}}{zoom}

\item{\code{visible}}{visible}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_worksheet"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_worksheet}{}}}
\subsection{Method \code{add_worksheet()}}{
Add worksheet to the \code{wbWorkbook} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_worksheet(
  sheet = next_sheet(),
  grid_lines = TRUE,
  row_col_headers = TRUE,
  tab_color = NULL,
  zoom = 100,
  header = NULL,
  footer = NULL,
  odd_header = header,
  odd_footer = footer,
  even_header = header,
  even_footer = footer,
  first_header = header,
  first_footer = footer,
  visible = c("true", "false", "hidden", "visible", "veryhidden"),
  has_drawing = FALSE,
  paper_size = getOption("openxlsx2.paperSize", default = 9),
  orientation = getOption("openxlsx2.orientation", default = "portrait"),
  hdpi = getOption("openxlsx2.hdpi", default = getOption("openxlsx2.dpi", default = 300)),
  vdpi = getOption("openxlsx2.vdpi", default = getOption("openxlsx2.dpi", default = 300)),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{grid_lines}}{gridLines}

\item{\code{row_col_headers}}{rowColHeaders}

\item{\code{tab_color}}{tabColor}

\item{\code{zoom}}{zoom}

\item{\code{header}}{header}

\item{\code{footer}}{footer}

\item{\code{odd_header}}{oddHeader}

\item{\code{odd_footer}}{oddFooter}

\item{\code{even_header}}{evenHeader}

\item{\code{even_footer}}{evenFooter}

\item{\code{first_header}}{firstHeader}

\item{\code{first_footer}}{firstFooter}

\item{\code{visible}}{visible}

\item{\code{has_drawing}}{hasDrawing}

\item{\code{paper_size}}{paperSize}

\item{\code{orientation}}{orientation}

\item{\code{hdpi}}{hdpi}

\item{\code{vdpi}}{vdpi}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-clone_worksheet"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-clone_worksheet}{}}}
\subsection{Method \code{clone_worksheet()}}{
Clone a workbooksheet to another workbook
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$clone_worksheet(
  old = current_sheet(),
  new = next_sheet(),
  from = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{old}}{name of worksheet to clone}

\item{\code{new}}{name of new worksheet to add}

\item{\code{from}}{name of new worksheet to add}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_data"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_data}{}}}
\subsection{Method \code{add_data()}}{
add data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_data(
  sheet = current_sheet(),
  x,
  dims = wb_dims(start_row, start_col),
  start_col = 1,
  start_row = 1,
  array = FALSE,
  col_names = TRUE,
  row_names = FALSE,
  with_filter = FALSE,
  name = NULL,
  sep = ", ",
  apply_cell_style = TRUE,
  remove_cell_style = FALSE,
  na.strings = na_strings(),
  inline_strings = TRUE,
  enforce = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{x}}{x}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{start_col}}{startCol}

\item{\code{start_row}}{startRow}

\item{\code{array}}{array}

\item{\code{col_names}}{colNames}

\item{\code{row_names}}{rowNames}

\item{\code{with_filter}}{withFilter}

\item{\code{name}}{name}

\item{\code{sep}}{sep}

\item{\code{apply_cell_style}}{applyCellStyle}

\item{\code{remove_cell_style}}{if writing into existing cells, should the cell style be removed?}

\item{\code{na.strings}}{Value used for replacing \code{NA} values from \code{x}. Default
\code{na_strings()} uses the special \verb{#N/A} value within the workbook.}

\item{\code{inline_strings}}{write characters as inline strings}

\item{\code{enforce}}{enforce that selected dims is filled. For this to work, \code{dims} must match \code{x}}

\item{\code{...}}{additional arguments}

\item{\code{return}}{The \code{wbWorkbook} object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_data_table"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_data_table}{}}}
\subsection{Method \code{add_data_table()}}{
add a data table
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_data_table(
  sheet = current_sheet(),
  x,
  dims = wb_dims(start_row, start_col),
  start_col = 1,
  start_row = 1,
  col_names = TRUE,
  row_names = FALSE,
  table_style = "TableStyleLight9",
  table_name = NULL,
  with_filter = TRUE,
  sep = ", ",
  first_column = FALSE,
  last_column = FALSE,
  banded_rows = TRUE,
  banded_cols = FALSE,
  apply_cell_style = TRUE,
  remove_cell_style = FALSE,
  na.strings = na_strings(),
  inline_strings = TRUE,
  total_row = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{x}}{x}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{start_col}}{startCol}

\item{\code{start_row}}{startRow}

\item{\code{col_names}}{colNames}

\item{\code{row_names}}{rowNames}

\item{\code{table_style}}{tableStyle}

\item{\code{table_name}}{tableName}

\item{\code{with_filter}}{withFilter}

\item{\code{sep}}{sep}

\item{\code{first_column}}{firstColumn}

\item{\code{last_column}}{lastColumn}

\item{\code{banded_rows}}{bandedRows}

\item{\code{banded_cols}}{bandedCols}

\item{\code{apply_cell_style}}{applyCellStyle}

\item{\code{remove_cell_style}}{if writing into existing cells, should the cell style be removed?}

\item{\code{na.strings}}{Value used for replacing \code{NA} values from \code{x}. Default
\code{na_strings()} uses the special \verb{#N/A} value within the workbook.}

\item{\code{inline_strings}}{write characters as inline strings}

\item{\code{total_row}}{write total rows to table}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_pivot_table"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_pivot_table}{}}}
\subsection{Method \code{add_pivot_table()}}{
add pivot table
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_pivot_table(
  x,
  sheet = next_sheet(),
  dims = "A3",
  filter,
  rows,
  cols,
  data,
  fun,
  params,
  pivot_table,
  slicer,
  timeline
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{a wb_data object}

\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{the worksheet cell where the pivot table is placed}

\item{\code{filter}}{a character object with names used to filter}

\item{\code{rows}}{a character object with names used as rows}

\item{\code{cols}}{a character object with names used as cols}

\item{\code{data}}{a character object with names used as data}

\item{\code{fun}}{a character object of functions to be used with the data}

\item{\code{params}}{a list of parameters to modify pivot table creation}

\item{\code{pivot_table}}{a character object with a name for the pivot table}

\item{\code{slicer}}{a character object with names used as slicer}

\item{\code{timeline}}{a character object with names used as timeline}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\code{fun} can be either of AVERAGE, COUNT, COUNTA, MAX, MIN, PRODUCT, STDEV,
STDEVP, SUM, VAR, VARP
}

\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_slicer"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_slicer}{}}}
\subsection{Method \code{add_slicer()}}{
add pivot table
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_slicer(
  x,
  dims = "A1",
  sheet = current_sheet(),
  pivot_table,
  slicer,
  params
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{a wb_data object}

\item{\code{dims}}{the worksheet cell where the pivot table is placed}

\item{\code{sheet}}{The name of the sheet}

\item{\code{pivot_table}}{the name of a pivot table on the selected sheet}

\item{\code{slicer}}{a variable used as slicer for the pivot table}

\item{\code{params}}{a list of parameters to modify pivot table creation}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-remove_slicer"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-remove_slicer}{}}}
\subsection{Method \code{remove_slicer()}}{
add pivot table
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$remove_slicer(sheet = current_sheet())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_timeline"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_timeline}{}}}
\subsection{Method \code{add_timeline()}}{
add pivot table
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_timeline(
  x,
  dims = "A1",
  sheet = current_sheet(),
  pivot_table,
  timeline,
  params
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{a wb_data object}

\item{\code{dims}}{the worksheet cell where the pivot table is placed}

\item{\code{sheet}}{The name of the sheet}

\item{\code{pivot_table}}{the name of a pivot table on the selected sheet}

\item{\code{timeline}}{a variable used as timeline for the pivot table}

\item{\code{params}}{a list of parameters to modify pivot table creation}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-remove_timeline"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-remove_timeline}{}}}
\subsection{Method \code{remove_timeline()}}{
add pivot table
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$remove_timeline(sheet = current_sheet())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_formula"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_formula}{}}}
\subsection{Method \code{add_formula()}}{
Add formula
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_formula(
  sheet = current_sheet(),
  x,
  dims = wb_dims(start_row, start_col),
  start_col = 1,
  start_row = 1,
  array = FALSE,
  cm = FALSE,
  apply_cell_style = TRUE,
  remove_cell_style = FALSE,
  enforce = FALSE,
  shared = FALSE,
  name = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{x}}{x}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{start_col}}{startCol}

\item{\code{start_row}}{startRow}

\item{\code{array}}{array}

\item{\code{cm}}{cm}

\item{\code{apply_cell_style}}{applyCellStyle}

\item{\code{remove_cell_style}}{if writing into existing cells, should the cell style be removed?}

\item{\code{enforce}}{enforce dims}

\item{\code{shared}}{shared formula}

\item{\code{name}}{name}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_hyperlink"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_hyperlink}{}}}
\subsection{Method \code{add_hyperlink()}}{
Add hyperlink
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_hyperlink(
  sheet = current_sheet(),
  dims = "A1",
  target = NULL,
  tooltip = NULL,
  is_external = TRUE,
  col_names = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{sheet}

\item{\code{dims}}{dims}

\item{\code{target}}{target}

\item{\code{tooltip}}{tooltip}

\item{\code{is_external}}{is_external}

\item{\code{col_names}}{col_names}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-remove_hyperlink"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-remove_hyperlink}{}}}
\subsection{Method \code{remove_hyperlink()}}{
remove hyperlink
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$remove_hyperlink(sheet = current_sheet(), dims = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{sheet}

\item{\code{dims}}{dims}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_style"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_style}{}}}
\subsection{Method \code{add_style()}}{
add style
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_style(style = NULL, style_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{style}

\item{\code{style_name}}{style_name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-to_df"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-to_df}{}}}
\subsection{Method \code{to_df()}}{
to_df
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$to_df(
  sheet,
  start_row = NULL,
  start_col = NULL,
  row_names = FALSE,
  col_names = TRUE,
  skip_empty_rows = FALSE,
  skip_empty_cols = FALSE,
  skip_hidden_rows = FALSE,
  skip_hidden_cols = FALSE,
  rows = NULL,
  cols = NULL,
  detect_dates = TRUE,
  na.strings = "#N/A",
  na.numbers = NA,
  fill_merged_cells = FALSE,
  dims,
  show_formula = FALSE,
  convert = TRUE,
  types,
  named_region,
  keep_attributes = FALSE,
  check_names = FALSE,
  show_hyperlinks = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{Either sheet name or index. When missing the first sheet in the workbook is selected.}

\item{\code{start_row}}{first row to begin looking for data.}

\item{\code{start_col}}{first column to begin looking for data.}

\item{\code{row_names}}{If TRUE, the first col of data will be used as row names.}

\item{\code{col_names}}{If TRUE, the first row of data will be used as column names.}

\item{\code{skip_empty_rows}}{If TRUE, empty rows are skipped.}

\item{\code{skip_empty_cols}}{If TRUE, empty columns are skipped.}

\item{\code{skip_hidden_rows}}{If TRUE, hidden rows are skipped.}

\item{\code{skip_hidden_cols}}{If TRUE, hidden columns are skipped.}

\item{\code{rows}}{A numeric vector specifying which rows in the Excel file to read. If NULL, all rows are read.}

\item{\code{cols}}{A numeric vector specifying which columns in the Excel file to read. If NULL, all columns are read.}

\item{\code{detect_dates}}{If TRUE, attempt to recognize dates and perform conversion.}

\item{\code{na.strings}}{A character vector of strings which are to be interpreted as NA. Blank cells will be returned as NA.}

\item{\code{na.numbers}}{A numeric vector of digits which are to be interpreted as NA. Blank cells will be returned as NA.}

\item{\code{fill_merged_cells}}{If TRUE, the value in a merged cell is given to all cells within the merge.}

\item{\code{dims}}{Character string of type "A1:B2" as optional dimensions to be imported.}

\item{\code{show_formula}}{If TRUE, the underlying Excel formulas are shown.}

\item{\code{convert}}{If TRUE, a conversion to dates and numerics is attempted.}

\item{\code{types}}{A named numeric indicating, the type of the data. 0: character, 1: numeric, 2: date, 3: posixt, 4:logical. Names must match the returned data}

\item{\code{named_region}}{Character string with a named_region (defined name or table). If no sheet is selected, the first appearance will be selected.}

\item{\code{keep_attributes}}{If TRUE additional attributes are returned. (These are used internally to define a cell type.)}

\item{\code{check_names}}{If TRUE then the names of the variables in the data frame are checked to ensure that they are syntactically valid variable names.}

\item{\code{show_hyperlinks}}{If \code{TRUE} instead of the displayed text, hyperlink targets are shown.}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a data frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-load"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-load}{}}}
\subsection{Method \code{load()}}{
load workbook
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$load(file, sheet, data_only = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{file}

\item{\code{sheet}}{The name of the sheet}

\item{\code{data_only}}{data_only}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-save"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-save}{}}}
\subsection{Method \code{save()}}{
Save the workbook
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$save(file = self$path, overwrite = TRUE, path = NULL, flush = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{The path to save the workbook to}

\item{\code{overwrite}}{If \code{FALSE}, will not overwrite when \code{path} exists}

\item{\code{path}}{Deprecated argument previously used for file. Please use file in new code.}

\item{\code{flush}}{Experimental, streams the worksheet file to disk}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-open"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-open}{}}}
\subsection{Method \code{open()}}{
open wbWorkbook in Excel.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$open(interactive = NA, flush = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{interactive}}{If \code{FALSE} will throw a warning and not open the path.
This can be manually set to \code{TRUE}, otherwise when \code{NA} (default) uses
the value returned from \code{\link[base:interactive]{base::interactive()}}}

\item{\code{flush}}{flush}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
minor helper wrapping xl_open which does the entire same thing
}

\subsection{Returns}{
The \code{wbWorkbook}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-buildTable"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-buildTable}{}}}
\subsection{Method \code{buildTable()}}{
Build table
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$buildTable(
  sheet = current_sheet(),
  colNames,
  ref,
  showColNames,
  tableStyle,
  tableName,
  withFilter = TRUE,
  totalsRowCount = 0,
  totalLabel = FALSE,
  showFirstColumn = 0,
  showLastColumn = 0,
  showRowStripes = 1,
  showColumnStripes = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{colNames}}{colNames}

\item{\code{ref}}{ref}

\item{\code{showColNames}}{showColNames}

\item{\code{tableStyle}}{tableStyle}

\item{\code{tableName}}{tableName}

\item{\code{withFilter}}{withFilter}

\item{\code{totalsRowCount}}{totalsRowCount}

\item{\code{totalLabel}}{totalLabel}

\item{\code{showFirstColumn}}{showFirstColumn}

\item{\code{showLastColumn}}{showLastColumn}

\item{\code{showRowStripes}}{showRowStripes}

\item{\code{showColumnStripes}}{showColumnStripes}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorksheet} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-update_table"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-update_table}{}}}
\subsection{Method \code{update_table()}}{
update a data_table
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$update_table(sheet = current_sheet(), dims = "A1", tabname)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{tabname}}{a tablename}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorksheet} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-copy_cells"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-copy_cells}{}}}
\subsection{Method \code{copy_cells()}}{
copy cells around in a workbook
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$copy_cells(
  sheet = current_sheet(),
  dims = "A1",
  data,
  as_value = FALSE,
  as_ref = FALSE,
  transpose = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{data}}{a wb_data object}

\item{\code{as_value}}{should a copy of the value be written}

\item{\code{as_ref}}{should references to the cell be written}

\item{\code{transpose}}{should the data be written transposed}

\item{\code{...}}{additional arguments passed to add_data() if used with \code{as_value}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorksheet} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-get_base_font"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-get_base_font}{}}}
\subsection{Method \code{get_base_font()}}{
Get the base font
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$get_base_font()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of of the font
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-set_base_font"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-set_base_font}{}}}
\subsection{Method \code{set_base_font()}}{
Set the base font
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$set_base_font(
  font_size = 11,
  font_color = wb_color(theme = "1"),
  font_name = "Aptos Narrow",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{font_size}}{fontSize}

\item{\code{font_color}}{font_color}

\item{\code{font_name}}{font_name}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-get_base_colors"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-get_base_colors}{}}}
\subsection{Method \code{get_base_colors()}}{
Get the base color
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$get_base_colors(xml = FALSE, plot = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{xml}

\item{\code{plot}}{plot}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-get_base_colours"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-get_base_colours}{}}}
\subsection{Method \code{get_base_colours()}}{
Get the base colour
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$get_base_colours(xml = FALSE, plot = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{xml}

\item{\code{plot}}{plot}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-set_base_colors"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-set_base_colors}{}}}
\subsection{Method \code{set_base_colors()}}{
Set the base color
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$set_base_colors(theme = "Office", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{theme}}{theme}

\item{\code{...}}{...}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-set_base_colours"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-set_base_colours}{}}}
\subsection{Method \code{set_base_colours()}}{
Set the base colour
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$set_base_colours(theme = "Office", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{theme}}{theme}

\item{\code{...}}{...}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-get_bookview"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-get_bookview}{}}}
\subsection{Method \code{get_bookview()}}{
Get the book views
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$get_bookview()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A dataframe with the bookview properties
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-remove_bookview"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-remove_bookview}{}}}
\subsection{Method \code{remove_bookview()}}{
Get the book views
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$remove_bookview(view = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{view}}{view}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-set_bookview"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-set_bookview}{}}}
\subsection{Method \code{set_bookview()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$set_bookview(
  active_tab = NULL,
  auto_filter_date_grouping = NULL,
  first_sheet = NULL,
  minimized = NULL,
  show_horizontal_scroll = NULL,
  show_sheet_tabs = NULL,
  show_vertical_scroll = NULL,
  tab_ratio = NULL,
  visibility = NULL,
  window_height = NULL,
  window_width = NULL,
  x_window = NULL,
  y_window = NULL,
  view = 1L,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{active_tab}}{activeTab}

\item{\code{auto_filter_date_grouping}}{autoFilterDateGrouping}

\item{\code{first_sheet}}{firstSheet}

\item{\code{minimized}}{minimized}

\item{\code{show_horizontal_scroll}}{showHorizontalScroll}

\item{\code{show_sheet_tabs}}{showSheetTabs}

\item{\code{show_vertical_scroll}}{showVerticalScroll}

\item{\code{tab_ratio}}{tabRatio}

\item{\code{visibility}}{visibility}

\item{\code{window_height}}{windowHeight}

\item{\code{window_width}}{windowWidth}

\item{\code{x_window}}{xWindow}

\item{\code{y_window}}{yWindow}

\item{\code{view}}{view}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-get_sheet_names"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-get_sheet_names}{}}}
\subsection{Method \code{get_sheet_names()}}{
Get sheet names
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$get_sheet_names(escape = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{escape}}{Logical if the xml special characters are escaped}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{named} \code{character} vector of sheet names in their order.  The
names represent the original value of the worksheet prior to any
character substitutions.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-set_sheet_names"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-set_sheet_names}{}}}
\subsection{Method \code{set_sheet_names()}}{
Sets a sheet name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$set_sheet_names(old = NULL, new)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{old}}{Old sheet name}

\item{\code{new}}{New sheet name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-set_row_heights"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-set_row_heights}{}}}
\subsection{Method \code{set_row_heights()}}{
Sets a row height for a sheet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$set_row_heights(
  sheet = current_sheet(),
  rows,
  heights = NULL,
  hidden = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{rows}}{rows}

\item{\code{heights}}{heights}

\item{\code{hidden}}{hidden}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-remove_row_heights"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-remove_row_heights}{}}}
\subsection{Method \code{remove_row_heights()}}{
Removes a row height for a sheet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$remove_row_heights(sheet = current_sheet(), rows)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{rows}}{rows}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-createCols"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-createCols}{}}}
\subsection{Method \code{createCols()}}{
creates column object for worksheet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$createCols(sheet = current_sheet(), n, beg, end)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{n}}{n}

\item{\code{beg}}{beg}

\item{\code{end}}{end}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-group_cols"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-group_cols}{}}}
\subsection{Method \code{group_cols()}}{
Group cols
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$group_cols(
  sheet = current_sheet(),
  cols,
  collapsed = FALSE,
  levels = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{cols}}{cols}

\item{\code{collapsed}}{collapsed}

\item{\code{levels}}{levels}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-ungroup_cols"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-ungroup_cols}{}}}
\subsection{Method \code{ungroup_cols()}}{
ungroup cols
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$ungroup_cols(sheet = current_sheet(), cols)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{cols}}{columns}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-remove_col_widths"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-remove_col_widths}{}}}
\subsection{Method \code{remove_col_widths()}}{
Remove row heights from a worksheet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$remove_col_widths(sheet = current_sheet(), cols)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{A name or index of a worksheet}

\item{\code{cols}}{Indices of columns to remove custom width (if any) from.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-set_col_widths"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-set_col_widths}{}}}
\subsection{Method \code{set_col_widths()}}{
Set column widths
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$set_col_widths(
  sheet = current_sheet(),
  cols,
  widths = 8.43,
  hidden = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{cols}}{cols}

\item{\code{widths}}{Width of columns}

\item{\code{hidden}}{A logical vector to determine which cols are hidden; values
are repeated across length of \code{cols}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-group_rows"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-group_rows}{}}}
\subsection{Method \code{group_rows()}}{
Group rows
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$group_rows(
  sheet = current_sheet(),
  rows,
  collapsed = FALSE,
  levels = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{rows}}{rows}

\item{\code{collapsed}}{collapsed}

\item{\code{levels}}{levels}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-ungroup_rows"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-ungroup_rows}{}}}
\subsection{Method \code{ungroup_rows()}}{
ungroup rows
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$ungroup_rows(sheet = current_sheet(), rows)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{rows}}{rows}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-remove_worksheet"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-remove_worksheet}{}}}
\subsection{Method \code{remove_worksheet()}}{
Remove a worksheet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$remove_worksheet(sheet = current_sheet())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The worksheet to delete}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_data_validation"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_data_validation}{}}}
\subsection{Method \code{add_data_validation()}}{
Adds data validation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_data_validation(
  sheet = current_sheet(),
  dims = "A1",
  type,
  operator,
  value,
  allow_blank = TRUE,
  show_input_msg = TRUE,
  show_error_msg = TRUE,
  error_style = NULL,
  error_title = NULL,
  error = NULL,
  prompt_title = NULL,
  prompt = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{type}}{type}

\item{\code{operator}}{operator}

\item{\code{value}}{value}

\item{\code{allow_blank}}{allowBlank}

\item{\code{show_input_msg}}{showInputMsg}

\item{\code{show_error_msg}}{showErrorMsg}

\item{\code{error_style}}{The icon shown and the options how to deal with such inputs. Default "stop" (cancel), else "information" (prompt popup) or "warning" (prompt accept or change input)}

\item{\code{error_title}}{The error title}

\item{\code{error}}{The error text}

\item{\code{prompt_title}}{The prompt title}

\item{\code{prompt}}{The prompt text}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-merge_cells"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-merge_cells}{}}}
\subsection{Method \code{merge_cells()}}{
Set cell merging for a sheet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$merge_cells(
  sheet = current_sheet(),
  dims = NULL,
  solve = FALSE,
  direction = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{solve}}{logical if intersecting cells should be solved}

\item{\code{direction}}{direction in which to split the cell merging. Allows "row" or "col".}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-unmerge_cells"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-unmerge_cells}{}}}
\subsection{Method \code{unmerge_cells()}}{
Removes cell merging for a sheet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$unmerge_cells(sheet = current_sheet(), dims = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-freeze_pane"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-freeze_pane}{}}}
\subsection{Method \code{freeze_pane()}}{
Set freeze panes for a sheet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$freeze_pane(
  sheet = current_sheet(),
  first_active_row = NULL,
  first_active_col = NULL,
  first_row = FALSE,
  first_col = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{first_active_row}}{first_active_row}

\item{\code{first_active_col}}{first_active_col}

\item{\code{first_row}}{first_row}

\item{\code{first_col}}{first_col}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_comment"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_comment}{}}}
\subsection{Method \code{add_comment()}}{
Add comment
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_comment(sheet = current_sheet(), dims = "A1", comment, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{row and column as spreadsheet dimension, e.g. "A1"}

\item{\code{comment}}{a comment to apply to the worksheet}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-get_comment"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-get_comment}{}}}
\subsection{Method \code{get_comment()}}{
Get comments
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$get_comment(sheet = current_sheet(), dims = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{sheet}

\item{\code{dims}}{dims}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame containing comments
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-remove_comment"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-remove_comment}{}}}
\subsection{Method \code{remove_comment()}}{
Remove comment
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$remove_comment(sheet = current_sheet(), dims = "A1", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{row and column as spreadsheet dimension, e.g. "A1"}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_thread"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_thread}{}}}
\subsection{Method \code{add_thread()}}{
add threaded comment to worksheet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_thread(
  sheet = current_sheet(),
  dims = "A1",
  comment = NULL,
  person_id,
  reply = FALSE,
  resolve = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{comment}}{the comment to add}

\item{\code{person_id}}{the person Id this should be added for}

\item{\code{reply}}{logical if the comment is a reply}

\item{\code{resolve}}{logical if the comment should be marked as resolved}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-get_thread"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-get_thread}{}}}
\subsection{Method \code{get_thread()}}{
Get threads
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$get_thread(sheet = current_sheet(), dims = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{sheet}

\item{\code{dims}}{dims}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame containing threads
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_conditional_formatting"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_conditional_formatting}{}}}
\subsection{Method \code{add_conditional_formatting()}}{
Add conditional formatting
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_conditional_formatting(
  sheet = current_sheet(),
  dims = NULL,
  rule = NULL,
  style = NULL,
  type = c("expression", "colorScale", "dataBar", "iconSet", "duplicatedValues",
    "uniqueValues", "containsErrors", "notContainsErrors", "containsBlanks",
    "notContainsBlanks", "containsText", "notContainsText", "beginsWith", "endsWith",
    "between", "topN", "bottomN"),
  params = list(showValue = TRUE, gradient = TRUE, border = TRUE, percent = FALSE, rank =
    5L),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{rule}}{rule}

\item{\code{style}}{style}

\item{\code{type}}{type}

\item{\code{params}}{Additional parameters}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-remove_conditional_formatting"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-remove_conditional_formatting}{}}}
\subsection{Method \code{remove_conditional_formatting()}}{
Remove conditional formatting
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$remove_conditional_formatting(
  sheet = current_sheet(),
  dims = NULL,
  first = FALSE,
  last = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{sheet}

\item{\code{dims}}{dims}

\item{\code{first}}{first}

\item{\code{last}}{last}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_image"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_image}{}}}
\subsection{Method \code{add_image()}}{
Insert an image into a sheet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_image(
  sheet = current_sheet(),
  dims = "A1",
  file,
  width = 6,
  height = 3,
  row_offset = 0,
  col_offset = 0,
  units = "in",
  dpi = 300,
  address = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{file}}{file}

\item{\code{width}}{width}

\item{\code{height}}{height}

\item{\code{row_offset, col_offset}}{offsets}

\item{\code{units}}{units}

\item{\code{dpi}}{dpi}

\item{\code{address}}{address}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_plot"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_plot}{}}}
\subsection{Method \code{add_plot()}}{
Add plot. A wrapper for add_image()
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_plot(
  sheet = current_sheet(),
  dims = "A1",
  width = 6,
  height = 4,
  row_offset = 0,
  col_offset = 0,
  file_type = "png",
  units = "in",
  dpi = 300,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{width}}{width}

\item{\code{height}}{height}

\item{\code{row_offset, col_offset}}{offsets}

\item{\code{file_type}}{fileType}

\item{\code{units}}{units}

\item{\code{dpi}}{dpi}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_drawing"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_drawing}{}}}
\subsection{Method \code{add_drawing()}}{
Add xml drawing
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_drawing(
  sheet = current_sheet(),
  dims = "A1",
  xml,
  col_offset = 0,
  row_offset = 0,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{xml}}{xml}

\item{\code{col_offset, row_offset}}{offsets for column and row}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_chart_xml"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_chart_xml}{}}}
\subsection{Method \code{add_chart_xml()}}{
Add xml chart
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_chart_xml(
  sheet = current_sheet(),
  dims = NULL,
  xml,
  col_offset = 0,
  row_offset = 0,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{xml}}{xml}

\item{\code{col_offset, row_offset}}{positioning parameters}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_mschart"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_mschart}{}}}
\subsection{Method \code{add_mschart()}}{
Add mschart chart to the workbook
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_mschart(
  sheet = current_sheet(),
  dims = NULL,
  graph,
  col_offset = 0,
  row_offset = 0,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{the dimensions where the sheet will appear}

\item{\code{graph}}{mschart graph}

\item{\code{col_offset, row_offset}}{offsets for column and row}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_form_control"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_form_control}{}}}
\subsection{Method \code{add_form_control()}}{
Add form control to workbook
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_form_control(
  sheet = current_sheet(),
  dims = "A1",
  type = c("Checkbox", "Radio", "Drop"),
  text = NULL,
  link = NULL,
  range = NULL,
  checked = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{type}}{type}

\item{\code{text}}{text}

\item{\code{link}}{link}

\item{\code{range}}{range}

\item{\code{checked}}{checked}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-print"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-print}{}}}
\subsection{Method \code{print()}}{
Prints the \code{wbWorkbook} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \code{wbWorkbook} object, invisibly; called for its side-effects
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-protect"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-protect}{}}}
\subsection{Method \code{protect()}}{
Protect a workbook
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$protect(
  protect = TRUE,
  password = NULL,
  lock_structure = FALSE,
  lock_windows = FALSE,
  type = 1,
  file_sharing = FALSE,
  username = unname(Sys.info()["user"]),
  read_only_recommended = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{protect}}{protect}

\item{\code{password}}{password}

\item{\code{lock_structure}}{lock_structure}

\item{\code{lock_windows}}{lock_windows}

\item{\code{type}}{type}

\item{\code{file_sharing}}{file_sharing}

\item{\code{username}}{username}

\item{\code{read_only_recommended}}{read_only_recommended}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-protect_worksheet"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-protect_worksheet}{}}}
\subsection{Method \code{protect_worksheet()}}{
protect worksheet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$protect_worksheet(
  sheet = current_sheet(),
  protect = TRUE,
  password = NULL,
  properties = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{protect}}{protect}

\item{\code{password}}{password}

\item{\code{properties}}{A character vector of properties to lock.  Can be one
or more of the following: \code{"selectLockedCells"},
\code{"selectUnlockedCells"}, \code{"formatCells"}, \code{"formatColumns"},
\code{"formatRows"}, \code{"insertColumns"}, \code{"insertRows"},
\code{"insertHyperlinks"}, \code{"deleteColumns"}, \code{"deleteRows"}, \code{"sort"},
\code{"autoFilter"}, \code{"pivotTables"}, \code{"objects"}, \code{"scenarios"}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-get_properties"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-get_properties}{}}}
\subsection{Method \code{get_properties()}}{
Get properties of a workbook
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$get_properties()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-set_properties"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-set_properties}{}}}
\subsection{Method \code{set_properties()}}{
Set a property of a workbook
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$set_properties(
  creator = NULL,
  title = NULL,
  subject = NULL,
  category = NULL,
  datetime_created = NULL,
  datetime_modified = NULL,
  modifier = NULL,
  keywords = NULL,
  comments = NULL,
  manager = NULL,
  company = NULL,
  custom = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{creator}}{character vector of creators. Duplicated are ignored.}

\item{\code{title, subject, category, datetime_created, datetime_modified, modifier, keywords, comments, manager, company, custom}}{A workbook property to set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_mips"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_mips}{}}}
\subsection{Method \code{add_mips()}}{
add mips string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_mips(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{A mips string added to self$custom}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-get_mips"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-get_mips}{}}}
\subsection{Method \code{get_mips()}}{
get mips string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$get_mips(single_xml = TRUE, quiet = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{single_xml}}{single_xml}

\item{\code{quiet}}{quiet}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-set_creators"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-set_creators}{}}}
\subsection{Method \code{set_creators()}}{
Set creator(s)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$set_creators(creators)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{creators}}{A character vector of creators to set.  Duplicates are
ignored.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_creators"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_creators}{}}}
\subsection{Method \code{add_creators()}}{
Add creator(s)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_creators(creators)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{creators}}{A character vector of creators to add.  Duplicates are
ignored.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-remove_creators"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-remove_creators}{}}}
\subsection{Method \code{remove_creators()}}{
Remove creator(s)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$remove_creators(creators)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{creators}}{A character vector of creators to remove.  All duplicated
are removed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-set_last_modified_by"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-set_last_modified_by}{}}}
\subsection{Method \code{set_last_modified_by()}}{
Change the last modified by
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$set_last_modified_by(name, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{A new value}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-set_page_setup"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-set_page_setup}{}}}
\subsection{Method \code{set_page_setup()}}{
set_page_setup() this function is intended to supersede page_setup(), but is not yet stable
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$set_page_setup(
  sheet = current_sheet(),
  black_and_white = NULL,
  cell_comments = NULL,
  copies = NULL,
  draft = NULL,
  errors = NULL,
  first_page_number = NULL,
  id = NULL,
  page_order = NULL,
  paper_height = NULL,
  paper_width = NULL,
  hdpi = NULL,
  vdpi = NULL,
  use_first_page_number = NULL,
  use_printer_defaults = NULL,
  orientation = NULL,
  scale = NULL,
  left = 0.7,
  right = 0.7,
  top = 0.75,
  bottom = 0.75,
  header = 0.3,
  footer = 0.3,
  fit_to_width = FALSE,
  fit_to_height = FALSE,
  paper_size = NULL,
  print_title_rows = NULL,
  print_title_cols = NULL,
  summary_row = NULL,
  summary_col = NULL,
  tab_color = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{black_and_white}}{black_and_white}

\item{\code{cell_comments}}{cell_comment}

\item{\code{copies}}{copies}

\item{\code{draft}}{draft}

\item{\code{errors}}{errors}

\item{\code{first_page_number}}{first_page_number}

\item{\code{id}}{id}

\item{\code{page_order}}{page_order}

\item{\code{paper_height, paper_width}}{paper size}

\item{\code{hdpi, vdpi}}{horizontal and vertical dpi}

\item{\code{use_first_page_number}}{use_first_page_number}

\item{\code{use_printer_defaults}}{use_printer_defaults}

\item{\code{orientation}}{orientation}

\item{\code{scale}}{scale}

\item{\code{left}}{left}

\item{\code{right}}{right}

\item{\code{top}}{top}

\item{\code{bottom}}{bottom}

\item{\code{header}}{header}

\item{\code{footer}}{footer}

\item{\code{fit_to_width}}{fitToWidth}

\item{\code{fit_to_height}}{fitToHeight}

\item{\code{paper_size}}{paperSize}

\item{\code{print_title_rows}}{printTitleRows}

\item{\code{print_title_cols}}{printTitleCols}

\item{\code{summary_row}}{summaryRow}

\item{\code{summary_col}}{summaryCol}

\item{\code{tab_color}}{tabColor}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-page_setup"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-page_setup}{}}}
\subsection{Method \code{page_setup()}}{
page_setup()
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$page_setup(
  sheet = current_sheet(),
  orientation = NULL,
  scale = 100,
  left = 0.7,
  right = 0.7,
  top = 0.75,
  bottom = 0.75,
  header = 0.3,
  footer = 0.3,
  fit_to_width = FALSE,
  fit_to_height = FALSE,
  paper_size = NULL,
  print_title_rows = NULL,
  print_title_cols = NULL,
  summary_row = NULL,
  summary_col = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{orientation}}{orientation}

\item{\code{scale}}{scale}

\item{\code{left}}{left}

\item{\code{right}}{right}

\item{\code{top}}{top}

\item{\code{bottom}}{bottom}

\item{\code{header}}{header}

\item{\code{footer}}{footer}

\item{\code{fit_to_width}}{fitToWidth}

\item{\code{fit_to_height}}{fitToHeight}

\item{\code{paper_size}}{paperSize}

\item{\code{print_title_rows}}{printTitleRows}

\item{\code{print_title_cols}}{printTitleCols}

\item{\code{summary_row}}{summaryRow}

\item{\code{summary_col}}{summaryCol}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-set_header_footer"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-set_header_footer}{}}}
\subsection{Method \code{set_header_footer()}}{
Sets headers and footers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$set_header_footer(
  sheet = current_sheet(),
  header = NULL,
  footer = NULL,
  even_header = NULL,
  even_footer = NULL,
  first_header = NULL,
  first_footer = NULL,
  align_with_margins = NULL,
  scale_with_doc = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{header}}{header}

\item{\code{footer}}{footer}

\item{\code{even_header}}{evenHeader}

\item{\code{even_footer}}{evenFooter}

\item{\code{first_header}}{firstHeader}

\item{\code{first_footer}}{firstFooter}

\item{\code{align_with_margins}}{align_with_margins}

\item{\code{scale_with_doc}}{scale_with_doc}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-get_tables"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-get_tables}{}}}
\subsection{Method \code{get_tables()}}{
get tables
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$get_tables(sheet = current_sheet())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The sheet tables.  \code{character()} if empty
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-remove_tables"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-remove_tables}{}}}
\subsection{Method \code{remove_tables()}}{
remove tables
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$remove_tables(sheet = current_sheet(), table, remove_data = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{table}}{table}

\item{\code{remove_data}}{removes the data as well}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_filter"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_filter}{}}}
\subsection{Method \code{add_filter()}}{
add filters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_filter(sheet = current_sheet(), rows, cols)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{rows}}{rows}

\item{\code{cols}}{cols}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-remove_filter"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-remove_filter}{}}}
\subsection{Method \code{remove_filter()}}{
remove filters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$remove_filter(sheet = current_sheet())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-set_grid_lines"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-set_grid_lines}{}}}
\subsection{Method \code{set_grid_lines()}}{
grid lines
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$set_grid_lines(sheet = current_sheet(), show = FALSE, print = show)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{show}}{show}

\item{\code{print}}{print}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-grid_lines"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-grid_lines}{}}}
\subsection{Method \code{grid_lines()}}{
grid lines
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$grid_lines(sheet = current_sheet(), show = FALSE, print = show)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{show}}{show}

\item{\code{print}}{print}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_named_region"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_named_region}{}}}
\subsection{Method \code{add_named_region()}}{
add a named region
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_named_region(
  sheet = current_sheet(),
  dims = "A1",
  name,
  local_sheet = FALSE,
  overwrite = FALSE,
  comment = NULL,
  hidden = NULL,
  custom_menu = NULL,
  description = NULL,
  is_function = NULL,
  function_group_id = NULL,
  help = NULL,
  local_name = NULL,
  publish_to_server = NULL,
  status_bar = NULL,
  vb_procedure = NULL,
  workbook_parameter = NULL,
  xml = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{name}}{name}

\item{\code{local_sheet}}{local_sheet}

\item{\code{overwrite}}{overwrite}

\item{\code{comment}}{comment}

\item{\code{hidden}}{hidden}

\item{\code{custom_menu}}{custom_menu}

\item{\code{description}}{description}

\item{\code{is_function}}{function}

\item{\code{function_group_id}}{function group id}

\item{\code{help}}{help}

\item{\code{local_name}}{localName}

\item{\code{publish_to_server}}{publish to server}

\item{\code{status_bar}}{status bar}

\item{\code{vb_procedure}}{vb procedure}

\item{\code{workbook_parameter}}{workbookParameter}

\item{\code{xml}}{xml}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-get_named_regions"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-get_named_regions}{}}}
\subsection{Method \code{get_named_regions()}}{
get named regions in a workbook
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$get_named_regions(tables = FALSE, x = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tables}}{Return tables as well?}

\item{\code{x}}{Not used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{data.frame} of named regions
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-remove_named_region"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-remove_named_region}{}}}
\subsection{Method \code{remove_named_region()}}{
remove a named region
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$remove_named_region(sheet = current_sheet(), name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-set_order"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-set_order}{}}}
\subsection{Method \code{set_order()}}{
set worksheet order
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$set_order(sheets)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheets}}{sheets}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-get_sheet_visibility"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-get_sheet_visibility}{}}}
\subsection{Method \code{get_sheet_visibility()}}{
Get sheet visibility
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$get_sheet_visibility()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns sheet visibility
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-set_sheet_visibility"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-set_sheet_visibility}{}}}
\subsection{Method \code{set_sheet_visibility()}}{
Set sheet visibility
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$set_sheet_visibility(sheet = current_sheet(), value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{value}}{value}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_page_break"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_page_break}{}}}
\subsection{Method \code{add_page_break()}}{
Add a page break
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_page_break(sheet = current_sheet(), row = NULL, col = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{row}}{row}

\item{\code{col}}{col}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-clean_sheet"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-clean_sheet}{}}}
\subsection{Method \code{clean_sheet()}}{
clean sheet (remove all values)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$clean_sheet(
  sheet = current_sheet(),
  dims = NULL,
  numbers = TRUE,
  characters = TRUE,
  styles = TRUE,
  merged_cells = TRUE,
  hyperlinks = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{numbers}}{remove all numbers}

\item{\code{characters}}{remove all characters}

\item{\code{styles}}{remove all styles}

\item{\code{merged_cells}}{remove all merged_cells}

\item{\code{hyperlinks}}{remove all hyperlinks}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorksheetObject}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_border"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_border}{}}}
\subsection{Method \code{add_border()}}{
create borders for cell region
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_border(
  sheet = current_sheet(),
  dims = "A1",
  bottom_color = wb_color(hex = "FF000000"),
  left_color = wb_color(hex = "FF000000"),
  right_color = wb_color(hex = "FF000000"),
  top_color = wb_color(hex = "FF000000"),
  bottom_border = "thin",
  left_border = "thin",
  right_border = "thin",
  top_border = "thin",
  inner_hgrid = NULL,
  inner_hcolor = NULL,
  inner_vgrid = NULL,
  inner_vcolor = NULL,
  update = FALSE,
  diagonal_up = NULL,
  diagonal_down = NULL,
  diagonal_color = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{dimensions on the worksheet e.g. "A1", "A1:A5", "A1:H5"}

\item{\code{bottom_color, left_color, right_color, top_color, inner_hcolor, inner_vcolor}}{a color, either something openxml knows or some RGB color}

\item{\code{left_border, right_border, top_border, bottom_border, inner_hgrid, inner_vgrid}}{the border style, if NULL no border is drawn. See create_border for possible border styles}

\item{\code{update}}{update}

\item{\code{diagonal_up, diagonal_down, diagonal_color}}{(optional) arguments for diagonal border lines}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_fill"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_fill}{}}}
\subsection{Method \code{add_fill()}}{
provide simple fill function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_fill(
  sheet = current_sheet(),
  dims = "A1",
  color = wb_color(hex = "FFFFFF00"),
  pattern = "solid",
  gradient_fill = "",
  every_nth_col = 1,
  every_nth_row = 1,
  bg_color = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{color}}{the colors to apply, e.g. yellow: wb_color(hex = "FFFFFF00")}

\item{\code{pattern}}{various default "none" but others are possible:
"solid", "mediumGray", "darkGray", "lightGray", "darkHorizontal",
"darkVertical", "darkDown", "darkUp", "darkGrid", "darkTrellis",
"lightHorizontal", "lightVertical", "lightDown", "lightUp", "lightGrid",
"lightTrellis", "gray125", "gray0625"}

\item{\code{gradient_fill}}{a gradient fill xml pattern.}

\item{\code{every_nth_col}}{which col should be filled}

\item{\code{every_nth_row}}{which row should be filled}

\item{\code{bg_color}}{(optional) background \code{\link[=wb_color]{wb_color()}}}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorksheetObject}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_font"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_font}{}}}
\subsection{Method \code{add_font()}}{
provide simple font function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_font(
  sheet = current_sheet(),
  dims = "A1",
  name = "Aptos Narrow",
  color = wb_color(hex = "FF000000"),
  size = "11",
  bold = "",
  italic = "",
  outline = "",
  strike = "",
  underline = "",
  charset = "",
  condense = "",
  extend = "",
  family = "",
  scheme = "",
  shadow = "",
  vert_align = "",
  update = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{name}}{font name: default "Aptos Narrow"}

\item{\code{color}}{rgb color: default "FF000000"}

\item{\code{size}}{font size: default "11",}

\item{\code{bold}}{bold}

\item{\code{italic}}{italic}

\item{\code{outline}}{outline}

\item{\code{strike}}{strike}

\item{\code{underline}}{underline}

\item{\code{charset}}{charset}

\item{\code{condense}}{condense}

\item{\code{extend}}{extend}

\item{\code{family}}{font family}

\item{\code{scheme}}{font scheme}

\item{\code{shadow}}{shadow}

\item{\code{vert_align}}{vertical alignment}

\item{\code{update}}{update}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_numfmt"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_numfmt}{}}}
\subsection{Method \code{add_numfmt()}}{
provide simple number format function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_numfmt(sheet = current_sheet(), dims = "A1", numfmt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{numfmt}}{number format id or a character of the format}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorksheetObject}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_cell_style"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_cell_style}{}}}
\subsection{Method \code{add_cell_style()}}{
provide simple cell style format function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_cell_style(
  sheet = current_sheet(),
  dims = "A1",
  apply_alignment = NULL,
  apply_border = NULL,
  apply_fill = NULL,
  apply_font = NULL,
  apply_number_format = NULL,
  apply_protection = NULL,
  border_id = NULL,
  ext_lst = NULL,
  fill_id = NULL,
  font_id = NULL,
  hidden = NULL,
  horizontal = NULL,
  indent = NULL,
  justify_last_line = NULL,
  locked = NULL,
  num_fmt_id = NULL,
  pivot_button = NULL,
  quote_prefix = NULL,
  reading_order = NULL,
  relative_indent = NULL,
  shrink_to_fit = NULL,
  text_rotation = NULL,
  vertical = NULL,
  wrap_text = NULL,
  xf_id = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{apply_alignment}}{logical apply alignment}

\item{\code{apply_border}}{logical apply border}

\item{\code{apply_fill}}{logical apply fill}

\item{\code{apply_font}}{logical apply font}

\item{\code{apply_number_format}}{logical apply number format}

\item{\code{apply_protection}}{logical apply protection}

\item{\code{border_id}}{border ID to apply}

\item{\code{ext_lst}}{extension list something like \verb{<extLst>...</extLst>}}

\item{\code{fill_id}}{fill ID to apply}

\item{\code{font_id}}{font ID to apply}

\item{\code{hidden}}{logical cell is hidden}

\item{\code{horizontal}}{align content horizontal ('left', 'center', 'right')}

\item{\code{indent}}{logical indent content}

\item{\code{justify_last_line}}{logical justify last line}

\item{\code{locked}}{logical cell is locked}

\item{\code{num_fmt_id}}{number format ID to apply}

\item{\code{pivot_button}}{unknown}

\item{\code{quote_prefix}}{unknown}

\item{\code{reading_order}}{reading order left to right}

\item{\code{relative_indent}}{relative indentation}

\item{\code{shrink_to_fit}}{logical shrink to fit}

\item{\code{text_rotation}}{degrees of text rotation}

\item{\code{vertical}}{vertical alignment of content ('top', 'center', 'bottom')}

\item{\code{wrap_text}}{wrap text in cell}

\item{\code{xf_id}}{xf ID to apply}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-get_cell_style"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-get_cell_style}{}}}
\subsection{Method \code{get_cell_style()}}{
get sheet style
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$get_cell_style(sheet = current_sheet(), dims)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a character vector of cell styles
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-set_cell_style"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-set_cell_style}{}}}
\subsection{Method \code{set_cell_style()}}{
set sheet style
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$set_cell_style(sheet = current_sheet(), dims, style)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{style}}{style}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorksheetObject}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-set_cell_style_across"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-set_cell_style_across}{}}}
\subsection{Method \code{set_cell_style_across()}}{
set style across columns and/or rows
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$set_cell_style_across(
  sheet = current_sheet(),
  style,
  cols = NULL,
  rows = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{sheet}

\item{\code{style}}{style}

\item{\code{cols}}{cols}

\item{\code{rows}}{rows}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_named_style"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_named_style}{}}}
\subsection{Method \code{add_named_style()}}{
set sheet style
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_named_style(
  sheet = current_sheet(),
  dims = "A1",
  name = "Normal",
  font_name = NULL,
  font_size = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{name}}{name}

\item{\code{font_name, font_size}}{optional else the default of the theme}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_dxfs_style"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_dxfs_style}{}}}
\subsection{Method \code{add_dxfs_style()}}{
create dxfs style
These styles are used with conditional formatting and custom table styles
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_dxfs_style(
  name,
  font_name = NULL,
  font_size = NULL,
  font_color = NULL,
  num_fmt = NULL,
  border = NULL,
  border_color = wb_color(getOption("openxlsx2.borderColor", "black")),
  border_style = getOption("openxlsx2.borderStyle", "thin"),
  bg_fill = NULL,
  gradient_fill = NULL,
  text_bold = NULL,
  text_italic = NULL,
  text_underline = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{the style name}

\item{\code{font_name}}{the font name}

\item{\code{font_size}}{the font size}

\item{\code{font_color}}{the font color (a \code{wb_color()} object)}

\item{\code{num_fmt}}{the number format}

\item{\code{border}}{logical if borders are applied}

\item{\code{border_color}}{the border color}

\item{\code{border_style}}{the border style}

\item{\code{bg_fill}}{any background fill}

\item{\code{gradient_fill}}{any gradient fill}

\item{\code{text_bold}}{logical if text is bold}

\item{\code{text_italic}}{logical if text is italic}

\item{\code{text_underline}}{logical if text is underlined}

\item{\code{...}}{additional arguments passed to \code{create_dxfs_style()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorksheetObject}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-clone_sheet_style"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-clone_sheet_style}{}}}
\subsection{Method \code{clone_sheet_style()}}{
clone style from one sheet to another
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$clone_sheet_style(from = current_sheet(), to)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{from}}{the worksheet you are cloning}

\item{\code{to}}{the worksheet the style is applied to}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_sparklines"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_sparklines}{}}}
\subsection{Method \code{add_sparklines()}}{
apply sparkline to worksheet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_sparklines(sheet = current_sheet(), sparklines)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{sparklines}}{sparkline created by \code{create_sparkline()}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_ignore_error"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_ignore_error}{}}}
\subsection{Method \code{add_ignore_error()}}{
Ignore error on worksheet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_ignore_error(
  sheet = current_sheet(),
  dims = "A1",
  calculated_column = FALSE,
  empty_cell_reference = FALSE,
  eval_error = FALSE,
  formula = FALSE,
  formula_range = FALSE,
  list_data_validation = FALSE,
  number_stored_as_text = FALSE,
  two_digit_text_year = FALSE,
  unlocked_formula = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{dims}}{Cell range in a sheet}

\item{\code{calculated_column}}{calculatedColumn}

\item{\code{empty_cell_reference}}{emptyCellReference}

\item{\code{eval_error}}{evalError}

\item{\code{formula}}{formula}

\item{\code{formula_range}}{formulaRange}

\item{\code{list_data_validation}}{listDataValidation}

\item{\code{number_stored_as_text}}{numberStoredAsText}

\item{\code{two_digit_text_year}}{twoDigitTextYear}

\item{\code{unlocked_formula}}{unlockedFormula}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-set_sheetview"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-set_sheetview}{}}}
\subsection{Method \code{set_sheetview()}}{
add sheetview
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$set_sheetview(
  sheet = current_sheet(),
  color_id = NULL,
  default_grid_color = NULL,
  right_to_left = NULL,
  show_formulas = NULL,
  show_grid_lines = NULL,
  show_outline_symbols = NULL,
  show_row_col_headers = NULL,
  show_ruler = NULL,
  show_white_space = NULL,
  show_zeros = NULL,
  tab_selected = NULL,
  top_left_cell = NULL,
  view = NULL,
  window_protection = NULL,
  workbook_view_id = NULL,
  zoom_scale = NULL,
  zoom_scale_normal = NULL,
  zoom_scale_page_layout_view = NULL,
  zoom_scale_sheet_layout_view = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}

\item{\code{color_id, default_grid_color}}{Integer: A color, default is 64}

\item{\code{right_to_left}}{Logical: if TRUE column ordering is right  to left}

\item{\code{show_formulas}}{Logical: if TRUE cell formulas are shown}

\item{\code{show_grid_lines}}{Logical: if TRUE the worksheet grid is shown}

\item{\code{show_outline_symbols}}{Logical: if TRUE outline symbols are shown}

\item{\code{show_row_col_headers}}{Logical: if TRUE row and column headers are shown}

\item{\code{show_ruler}}{Logical: if TRUE a ruler is shown in page layout view}

\item{\code{show_white_space}}{Logical: if TRUE margins are shown in page layout view}

\item{\code{show_zeros}}{Logical: if FALSE cells containing zero are shown blank if !showFormulas}

\item{\code{tab_selected}}{Integer: zero vector indicating the selected tab}

\item{\code{top_left_cell}}{Cell: the cell shown in the top left corner / or top right with rightToLeft}

\item{\code{view}}{View: "normal", "pageBreakPreview" or "pageLayout"}

\item{\code{window_protection}}{Logical: if TRUE the panes are protected}

\item{\code{workbook_view_id}}{integer: Pointing to some other view inside the workbook}

\item{\code{zoom_scale, zoom_scale_normal, zoom_scale_page_layout_view, zoom_scale_sheet_layout_view}}{Integer: the zoom scale should be between 10 and 400. These are values for current, normal etc.}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorksheetObject}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-add_person"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-add_person}{}}}
\subsection{Method \code{add_person()}}{
add person to workbook
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$add_person(
  name = NULL,
  id = NULL,
  user_id = NULL,
  provider_id = "None"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}

\item{\code{id}}{id}

\item{\code{user_id}}{user_id}

\item{\code{provider_id}}{provider_id}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-get_person"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-get_person}{}}}
\subsection{Method \code{get_person()}}{
description get person
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$get_person(name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-get_active_sheet"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-get_active_sheet}{}}}
\subsection{Method \code{get_active_sheet()}}{
description get active sheet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$get_active_sheet()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-set_active_sheet"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-set_active_sheet}{}}}
\subsection{Method \code{set_active_sheet()}}{
description set active sheet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$set_active_sheet(sheet = current_sheet())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-get_selected"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-get_selected}{}}}
\subsection{Method \code{get_selected()}}{
description get selected sheets
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$get_selected()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-set_selected"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-set_selected}{}}}
\subsection{Method \code{set_selected()}}{
set selected sheet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$set_selected(sheet = current_sheet())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sheet}}{The name of the sheet}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorkbook-clone"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorkbook-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorkbook$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
