% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimizationProblem-proto.R
\name{OptimizationProblem-class}
\alias{OptimizationProblem-class}
\alias{OptimizationProblem}
\title{Optimization problem class}
\description{
The \code{OptimizationProblem} class is used to represent an optimization
problem. Data are stored in memory and accessed using an external pointer.
\strong{Only experts should interact with this class directly.}
}
\section{Fields}{

\describe{

\item{$ptr}{\code{externalptr} object.}

\item{$data}{\code{list} object.}

}
}

\section{Usage}{

\code{x$print()}

\code{x$show()}

\code{x$repr()}

\code{x$ncol()}

\code{x$nrow()}

\code{x$ncell()}

\code{x$modelsense()}

\code{x$vtype()}

\code{x$obj()}

\code{x$pwlobj()}

\code{x$A()}

\code{x$rhs()}

\code{x$sense()}

\code{x$lb()}

\code{x$ub()}

\code{x$number_of_projects()}

\code{x$number_of_actions()}

\code{x$number_of_features()}

\code{x$number_of_branches()}

\code{x$row_ids()}

\code{x$col_ids()}

\code{x$get_data()}
}

\section{Arguments}{

\describe{
\item{ptr}{\code{externalptr} object.}
}
}

\section{Details}{

\describe{

\item{print}{print the object.}

\item{show}{show the object.}

\item{repr}{\code{character} representation of object.}

\item{ncol}{\code{integer} number of columns (variables) in model matrix.}

\item{nrow}{\code{integer} number of rows (constraints) in model matrix.}

\item{ncell}{\code{integer} number of cells in model matrix.}

\item{modelsense}{\code{character} model sense.}

\item{vtype}{\code{character} vector of variable types.}

\item{obj}{\code{numeric} vector containing the linear components of the
objective function.}

\item{pwlobj}{\code{list} object containing the piece-wise linear components
of the objective function.}

\item{A}{\link[Matrix:dgCMatrix-class]{Matrix::dgCMatrix} model matrix }

\item{rhs}{\code{numeric} vector of right-hand-side constraints.}

\item{sense}{\code{character} vector of constraint senses.}

\item{lb}{\code{numeric} vector of lower bounds for each decision variable.}

\item{ub}{\code{numeric} vector of upper bounds for each decision variable.}

\item{number_of_projects}{\code{integer} number of projects in the problem.}

\item{number_of_actions}{\code{integer} number of actions in the problem.}

\item{number_of_features}{\code{integer} number of features in the problem.}

\item{number_of_branches}{\code{integer} number of phylogenetic branches in
the problem.}

\item{col_ids}{\code{character} names describing each decision variable
(column) in the model matrix.}

\item{row_ids}{\code{character} names describing each constraint (row) in
in the model matrix.}

\item{get_data}{\code{list} containing additional data.}

}
}

