% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.optproj.R
\name{plot.optproj}
\alias{plot.optproj}
\title{Projection plots for optimization routines.}
\usage{
\method{plot}{optproj}(x, xnames, xind, equalize = FALSE, layout, xlab,
  ylab, ...)
}
\arguments{
\item{x}{An \code{optproj} object, i.e., output from function \code{\link{optim_proj}}.}

\item{xnames}{Optional vector of element names of potential solution for plot titles.}

\item{xind}{Integer or logical vector of indices indicating which projections should be plotted.  Defaults to all projection plots.}

\item{equalize}{If \code{TRUE}, narrows the range in each projection plot such that the y-value is more or less the same at either endpoint.}

\item{layout}{Optional vector giving the number of rows and columns in the plot layout.  For \code{nx} plots, defaults to \code{c(nr, nc)}, where \code{nr = floor(nx)} and \code{nc = ceiling(nx/nr)}.}

\item{xlab, ylab}{Outer x-axis and y-axis labels.}

\item{...}{Further arguments to be passed to or from other methods.}
}
\value{
A grid of projection plots, with vertical lines at the potential solution.
}
\description{
Projection plots for optimization routines.
}
