% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcPerformance.R
\name{calcPerformance}
\alias{calcPerformance}
\title{Attach portfolio performance and distance to target}
\usage{
calcPerformance(x)
}
\arguments{
\item{x}{An optimized optimLanduse object.}
}
\value{
An optimized optimLanduse object with attached portfolio performance.
}
\description{
The Portfolio performances are calculated and attached to the solved
optimLanduse object. Each performance measure describes the relative proportion to the maximum achievable
(the "target") of the indicator, given the current solution. The lowest performance of all indicators
is the degree of fulfillment of the worst performing
indicator. It can thus be interpreted as the guaranteed performance
under the worst-possible scenario. At least this proportion will be
achieved across all indicators.
}
\details{
For further information and calculation, see the supplement of Gosling et al. (2020),
Formula S5 (in the supplement of the paper) and also the paragraph
optimLanduse functions and workflow - Post-processing in Husmann et al. (n. d.).
}
\examples{
require(ggplot2)
require(readxl)

dat <- read_xlsx(exampleData("exampleGosling.xlsx"))
init <- initScenario(dat, uValue = 2,
                     optimisticRule = "expectation",
                     fixDistance = 3)
result <- solveScenario(x = init)
performance <- calcPerformance(result)

# Visualize the distance

ggplot(performance$scenarioTable,
       aes(x = indicator,
           y = performance,
           color = indicator)) +
geom_point() +
geom_hline(yintercept =
           min(performance$scenarioTable$performance),
          linetype = "dashed", color = "red") +
ylim(0, 1)
}
\references{
Gosling, E., Reith, E., Knoke T., Gerique, A., Paul, C. (2020): Exploring
farmer perceptions of agroforestry via multi-objective optimisation: a test application
in Eastern Panama. \emph{Agroforestry Systems} \strong{94}. \doi{10.1007/s10457-020-00519-0}

Husmann, K., von Groß, V., Bödeker, K., Fuchs, J. M., Paul, C., Knoke, T. (no date): optimLanduse:
A Package for Multiobjective Land-cover1Composition Optimization under Uncertainty. \emph{Methods
in Ecology and Management}. Under review.
}
