% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{nn_wgt}
\alias{nn_wgt}
\title{Nearest-neighbors weights}
\usage{
nn_wgt(Y, X, control = NULL, wgt = rep(1, length(Y)), lambda = 100,
  sigma = 1, test = F)
}
\arguments{
\item{Y}{outcome vector (must be numeric without NA's).}

\item{X}{numeric data frame or matrix of factors to be considered.}

\item{control}{numeric data frame or matrix of factors to control for. these are factors
that we can't consider while looking for the optimal intervention
(e.g. race).}

\item{wgt}{an optional vector of weights.}

\item{lambda}{the lagrange multiplier. also known as the shadow price of an
intervention.}

\item{sigma}{distance penalty for the nearest-neighbors method.}

\item{test}{if TRUE, returns weights matrix (only used for testing).}
}
\value{
vector of unadjusted weights under I = 1
}
\description{
Calculates unadjusted weights under I = 1, using the nearest-neighbors method
}
