% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optional.R
\name{opt_unwrap}
\alias{opt_unwrap}
\title{Option Unwrap}
\usage{
opt_unwrap(opt)
}
\arguments{
\item{opt}{The optional variable to cast back}
}
\value{
The object wrapped in \code{opt}. 
             \code{NULL} if \code{opt} is \code{none}.
}
\description{
Cast an optional object to its base type.
}
\details{
Since an optional can be used the same way as its
base type, there is no known scenario where this
function might be useful.
}
\examples{
a <- some(5)
class(a)
## [1] "optional"
a <- opt_unwrap(a)

class(a)
## [1] "numeric"
}
\seealso{
make_opt(), match_with()
}

