% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_option.R
\name{defining_options}
\alias{defining_options}
\alias{define_option}
\alias{define_options}
\title{Defining Options}
\usage{
define_option(option, ...)

define_options(...)
}
\arguments{
\item{option}{An option name to use}

\item{...}{Additional arguments passed to \code{\link[=option_spec]{option_spec()}}}
}
\value{
the package options environment
}
\description{
Define options which can be used throughout your package.
}
\details{
At their simplest, defining options lets you refer to a global option using a
shorthand option name throughout your package, with the added benefit of
looking for configurations in global options and environment variables.
}
\section{Functions}{
\itemize{
\item \code{define_option()}: Define an option. Unlike \code{\link[=define_options]{define_options()}}, this function allows detailed
customization of all option behaviors. Accepts either an \code{\link[=option_spec]{option_spec()}}
object, or an option named followed by arguments to provide to
\code{\link[=option_spec]{option_spec()}}.

\item \code{define_options()}: Define multiple options. This function provides a shorthand syntax for
succinctly defining many options. Arguments are defined in groups, each
starting with an unnamed description argument. For more details see Section
\emph{Non-Standard Evaluation}.

}}
\section{Non-Standard Evaluation}{


\code{define_options()} accepts arguments in a \emph{non-standard}
way, as groups of arguments which each are used to specify an option (See
\code{options_spec()}). Groups of arguments must start with an unnamed argument,
which provides the description for the argument, followed immediately by a
named argument providing the name of option and default value, followed by
any additional arguments to provie to \code{options_spec()}.

The environment in which options are defined is always assumed to be the
parent environment. If you'd prefer to specify options in a different
environment, this is best done using \code{define_option()} or
\verb{with(<env>, define_options(...))}.

Although \code{define_options()} provides all the functionality of
\code{define_option()} in a succinct shorthand, it is only recommended in cases
where the overwhelming majority of your options leverage default behaviors.
It is encouraged to use \code{define_option()} if you repeatedly need more
involved definitions to minimize non-standard evaluation bugs.
}

\examples{
define_options(
  "Whether execution should emit console output",
  quiet = FALSE,

  "Whether to use detailed console output (showcasing additional
  configuration parameters)",
  verbose = TRUE,
  envvar_fn = envvar_is_true()
)

define_option(
  "deprecations",
  desc = "Whether deprecation warnings should be suppressed automatically",
  default = FALSE,
  option_name = "MypackageDeprecations",
  envvar_name = "MYPACKAGE_ENVVARS_DEPRECATIONS"
)

}
