% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/batch_opt.R
\name{do.plain.mc}
\alias{do.plain.mc}
\title{Do plain monte carlo with target density}
\usage{
do.plain.mc(plainmc.N, mixture.param, fname = "f", rpname = "rp")
}
\arguments{
\item{plainmc.N}{number of samples}

\item{mixture.param}{mixture.param = list(p, J, ...), where \eqn{p} is the dimension of the sample, and \eqn{J} is the number of mixture components, including the defensive one. mixture.param should be compatible with user defined functions \emph{f(n, j, mixture.param), rp(n, mixture.param), rq(n, j, mixture.param), dp(xmat, mixture.param), dq(xmat, j, mixture.param)}}

\item{fname}{name of user defined function \emph{fname(xmat, j, mixture.param)}. \emph{xmat} is an \eqn{n \times p} matrix of \eqn{n} samples with \eqn{p} dimensions. \emph{fname} returns a vector of function values for each row in \emph{xmat}. \emph{fname} is defined for \eqn{j = 1, \cdots, J}. \eqn{j = 1, \cdots, J - 1} corresponds to different proposal mixture components, and \eqn{j = J} corresponds to the defensive mixture component.}

\item{rpname}{name of user definded function \emph{rpname(n, mixture.param)}. It generates \eqn{n} random samples from target distribution \emph{pname}. Parameters can be specified in \emph{mixture.param}. \emph{rpname} returns an \eqn{n \times p} matrix.}
}
\value{
a list of \describe{
  \item{plainmc.N}{number of samples for the plain monte carlo}
  \item{mu.hat}{estimated \eqn{E_p f} from plain monte carlos samples}
  \item{sd.hat}{estimated sd for \emph{mu.hat}}
}
}
\description{
Do plain monte carlo with target density
}

