################################################################################
# Tests for SubDivStrat, which wraps fmatch and provides some useful statistics
################################################################################

if(require("testthat")) {
context("SubDivStrat")

### Commented out because matched.distances = TRUE not implemented yet.
### test_that("Matched Distances", {
###   d <- matrix(c(1,2,3,4), nrow = 2, dimnames = list(c(1,2), c(3,4)))
###   # these values were generated by debugging the fullmatch function on:
###   #   fullmatch(d)  
###   # and then saving the call to SubDivStrat
###   max.cpt <- 2
###   min.cpt <- 0.5
###   tolerance <- 0.004
###   # omit.fraction is NULL
### 
###   res <- SubDivStrat(rownames = rownames(d), colnames = colnames(d), 
###                      distmat = d, max.cpt = max.cpt, min.cpt = min.cpt,
###                      tolerance = tolerance, omit.fraction = NULL)
### 
###   # result from .fullmatch
###   # cells
###   # 1 2 3 4 
###   # 1 2 1 2 
###   # 
###   # $err
###   # [1] -0.008
###   # 
###   # $match.distance
###   # [1] 0
###   
###   # if the pairs are 1-3, 2-4, the matched distances are c(1,4)
### 
###   expect_equivalent(res$match.distance, c(1,4))
### 
### })

test_that("No Warnings", {
  # make sure that no warnings issue from SubDivStrat under "usual" conditions
  old.opts <- options(warn = 2)
  d <- matrix(c(1,2,3,4), nrow = 2, dimnames = list(c(1,2), c(3,4)))
  # these values were generated by debugging the fullmatch function on:
  #   fullmatch(d)  
  # and then saving the call to SubDivStrat
  max.cpt <- 2
  min.cpt <- 0.5
  tolerance <- 0.004
  # omit.fraction is NULL
 
  res <- SubDivStrat(rownames = rownames(d), colnames = colnames(d), 
                     distspec = d, max.cpt = max.cpt, min.cpt = min.cpt,
                     tolerance = tolerance, omit.fraction = NULL)

  options(old.opts)
})

test_that("NA for unmatched items", {
  d <- matrix(c(1,2, 3,4, Inf, Inf), nrow = 2, dimnames = list(c(1,2), c(3,4, "U")))
  max.cpt <- 3
  min.cpt <- 0.5
  tolerance <- 0.005
  
  res <- SubDivStrat(rownames = rownames(d), colnames = colnames(d), 
                     distspec = d, max.cpt = max.cpt, min.cpt = min.cpt,
                     tolerance = tolerance, omit.fraction = NULL)

  expect_equal(length(res$cells), 5)

})
} # end require(test_that)
