\name{validDistanceSpecification}
\alias{validDistanceSpecification}
\title{(Internal) Validate that objects are valid distance specifications.}
\usage{
  validDistanceSpecification(distance,
    stopOnProblem = TRUE)
}
\arguments{
  \item{distance}{The object to test.}

  \item{stopOnProblem}{If \code{TRUE} (default) the
  function will raise an error for invalid objects.
  Otherwise, it returns a logical.}
}
\value{
  logical
}
\description{
  The functions \code{\link{fullmatch}} and
  \code{\link{pairmatch}} create optimal matchings of
  treated and control units given a matrix (or similar
  representation) of distances between treated and control
  units. These distance specifications must implement
  certain generic functions. This function checks that all
  necessary methods exist and the object can be used to
  specify distances in a way that the matching functions
  can use.
}

