% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Optmatch.R
\name{compare_optmatch}
\alias{compare_optmatch}
\title{Compares the equality of optmatch objects, ignoring attributes and group names.}
\usage{
compare_optmatch(o1, o2)
}
\arguments{
\item{o1}{First optmatch object.}

\item{o2}{Second optmatch object.}
}
\value{
TRUE if the two matches have the same memberships.
}
\description{
This checks the equality of two optmatch objects. The only bits that matter are unit names
and the grouping. Other bits such as attributes, group names, order, etc are ignored.
}
\details{
The names of the units can differ on any unmatched units, e.g., units whose value in the optmatch
object is \code{NA}. If matched objects have differing names, this is automatically \code{FALSE}.

Note this ignores the names of the subgroups. So four members in subgroups either
\code{c("a", "a", "b", "b")} or \code{c("b", "b", "a", "a")} would be identical to this call.
}

