% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat.R
\name{strat}
\alias{strat}
\title{Helper for object of class "strat"}
\usage{
strat(z, X, base_strata = NULL, refined_strata = NULL, details = NULL)
}
\arguments{
\item{z}{Vector of treatment assignment}

\item{X}{Covariate matrix or data.frame}

\item{base_strata}{Original strata, if they exist}

\item{refined_strata}{Refined strata, if they exist}

\item{details}{A list of details from the linear program.
Include X_std if calculated}
}
\value{
Object of class \code{strat} if valid
}
\description{
Creates an object of S3 class "strat"
}
\examples{
# Don't need to include any stratification
strat_object <- strat(z = rhc_X[, "z"], X = rhc_X[, !(colnames(rhc_X) \%in\% "z")])

# Can include base and/or refined stratification if desired
strat_object <- strat(z = rhc_X[, "z"], X = rhc_X[, !(colnames(rhc_X) \%in\% "z")],
                      base_strata = rep(1, nrow(rhc_X)),
                      refined_strata = NULL)
}
