% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment.R
\name{augment.orbital_class}
\alias{augment.orbital_class}
\title{Augment using orbital objects}
\usage{
\method{augment}{orbital_class}(x, new_data, ...)
}
\arguments{
\item{x}{An \link{orbital} object.}

\item{new_data}{A data frame or remote database table.}

\item{...}{Not currently used.}
}
\value{
A modified data frame or remote database table.
}
\description{
\code{\link[=augment]{augment()}} will add column(s) for predictions to the given data.
}
\details{
This function is a shorthand for the following code

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dplyr::bind_cols(
  predict(orbital_obj, new_data),
  new_data
)
}\if{html}{\out{</div>}}

Note that \code{\link[=augment]{augment()}} works better and safer than above as it also works on
data set in data bases.

This function is confirmed to not work work in spark data bases or arrow
tables.
}
\examples{
\dontshow{if (rlang::is_installed(c("recipes", "tidypredict", "workflows"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(workflows)
library(recipes)
library(parsnip)

rec_spec <- recipe(mpg ~ ., data = mtcars) |>
  step_normalize(all_numeric_predictors())

lm_spec <- linear_reg()

wf_spec <- workflow(rec_spec, lm_spec)

wf_fit <- fit(wf_spec, mtcars)

orbital_obj <- orbital(wf_fit)

augment(orbital_obj, mtcars)
\dontshow{\}) # examplesIf}
}
