% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/develop.R
\name{orderly_develop_start}
\alias{orderly_develop_start}
\alias{orderly_develop_status}
\alias{orderly_develop_clean}
\title{Develop an orderly report}
\usage{
orderly_develop_start(
  name = NULL,
  parameters = NULL,
  envir = parent.frame(),
  root = NULL,
  locate = TRUE,
  instance = NULL,
  use_draft = FALSE,
  remote = NULL
)

orderly_develop_status(name = NULL, root = NULL, locate = TRUE)

orderly_develop_clean(name = NULL, root = NULL, locate = TRUE)
}
\arguments{
\item{name}{Name of the report to develop (see
\code{\link[=orderly_list]{orderly_list()}}).  A leading \verb{src/} will be
removed if provided, allowing easier use of autocomplete.
Alternatively, the default of \code{NULL} is useful if you have
already set the working directory to be the source directory.}

\item{parameters}{Parameters passed to the report. A named list of
parameters declared in the \code{orderly.yml}.  Each parameter
must be a scalar character, numeric, integer or logical.}

\item{envir}{The parent of the environment that will be used to
evaluate the report script; by default a new environment will be
made with the global environment as the parent.}

\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}

\item{instance}{Select instance of the source database to be used,
where multiple instances are configured.  Use a single
\emph{unnamed} character string to indicate an instance to
match.  If given, then this name must be present in all
databases where instances are listed in
\code{orderly_config.yml}, and will be ignored by all database
where instances are not given.  See the "orderly" vignette for
further information.}

\item{use_draft}{Should draft reports be used for dependencies?
This should be used only in development.  Valid values are
logical (\code{TRUE}, \code{FALSE}) or use the string
\code{newer} to use draft reports where they are newer than
archive reports.  For consistency, \code{always} and
\code{never} are equivalent to \code{TRUE} and \code{FALSE},
respectively.}

\item{remote}{Remote to use to resolve dependencies.  Use this in
order to run a report with the same dependencies as are
available on a remote server, particularly when using \code{id = "latest"}.  Note that this is not the same as running
\code{\link[=orderly_pull_dependencies]{orderly_pull_dependencies()}}, then \code{orderly_run}
with \code{remote = NULL}, as the pull/run approach will use the
latest report in \emph{your} archive but the \code{remote = "remote"} approach will use the latest approach in the
\emph{remote} archive (which might be less recent).}
}
\value{
A character vector with the full path to the directory,
invisibly.
}
\description{
The functions \code{orderly_develop_start},
\code{orderly_develop_status} and \code{orderly_develop_clean}
provide a workflow for developing a report in much the same way as
one might write code outside of orderly.
\code{orderly_develop_start} will copy all files required (global
resources and dependencies) into the report source directory, as
well as collect all data and parameters - at this point the
directory can be developed in directly.  It will also load all
declared packages, and source all code files listed in the
\verb{packages:} and \verb{sources:} sections of your
\code{orderly.yml}.  \code{orderly_develop_status} provides
information about the status of files in the directory, while
\code{orderly_develop_clean} deletes all copied files.
}
\details{
These functions are designed to work within a report's \code{src}
directory.  For example, for a report \code{analysis} they will
alter or report on the directory \code{src/analysis}.  It is
intended that \code{orderly_develop_start} can be run repeatedly;
doing this will \emph{refresh} the contents of the directory if
upstream files have been updated.

Some degree of care should be used while using these functions.

Because \code{orderly_develop_start} copies files into your source
tree you should be careful to add these files to your
\code{.gitignore} files so that they are not included if using
git.  Rerunning \code{orderly_develop_start} will copy a fresh
copy of dependencies into your tree, overwriting files that are
there without warning.

Repeatedly running \code{orderly_develop_start} is "safe", in that
it will re-run through the setup steps, but beware that sourcing
functions is additive and never subtractive.  If you delete (or
rename) a function within a source file, it will not be removed
from your global environment.  Similarly, environment variables
will be loaded each time you call this, but no deletions will
happen.  When in doubt, restart your R session.

Note that these functions are much more permissive as to the state
of your \code{orderly.yml} than \code{\link[=orderly_run]{orderly_run()}} - in
particular, they will run, with a message, even if you have not
yet defined a \verb{script:} or any \verb{artefacts:}.

The \code{orderly_develop_clean} function will delete dependencies
without warning.
}
\examples{
path <- orderly::orderly_example("demo")

# This report uses a dependency - it requires that the file
# incoming.csv exists.  This file is created from the report 'other'
orderly::orderly_develop_status("use_dependency", root = path)

# Copy the required dependencies over, in this case from a draft report
orderly::orderly_run("other", list(nmin = 0), root = path, echo = FALSE)
orderly::orderly_develop_start("use_dependency", root = path,
                               use_draft = TRUE)

# Files have been copied across into the source directory
orderly::orderly_develop_status("use_dependency", root = path)

# The report can then be developed as needed, interactively.  After
# we're happy things can be cleaned up with
orderly::orderly_develop_clean("use_dependency", root = path)

}
