tabpej <-
function(m){
  # ----------------------------------------------------------------------------
  # coef = tabpej(m)
  # Coefficients of the polynomial expression of the BOS model.
  # input:
  #   m  number of categories
  # output:
  #   tab  array of dim m x m x m where tab[x,mu,] are the m coefficients
  #           s.t. p(x,mu,pi)= Sum_j ( tab[x,mu,j] * pi ^ (j-1) )
  # ----------------------------------------------------------------------------
  tab = array(0,c(m,m,m))
  if (m==2){
    tab[,,] = 0.5
    tab[1,2,2]=-0.5
    tab[2,1,2]=-0.5
  }
  if (m==3){
    tab[,,1]=1/3
    tab[,,2]=rbind(c(11/18,-5/18,-8/18),c(-1/6,10/18,-1/6),c(-8/18,-5/18,11/18))
    tab[,,3]=rbind(c(1/18,-1/18,1/9),c(-1/6,1/9,-1/6),c(1/9,-1/18,1/18))
  }
  if (m==4){
    tab[,,1]=rbind(c(1/4,1/4,1/4,1/4),c(1/4,1/4,1/4,1/4),c(1/4,1/4,1/4,1/4),c(1/4,1/4,1/4,1/4))
    tab[,,2]=rbind(c(61/96,-5/32,-5/16,-19/48),c(-1/48,55/96,-5/48,-7/32),c(-7/32,-5/48,55/96,-1/48),c(-19/48,-5/16,-5/32,61/96))
    tab[,,3]=rbind(c(1/9,-13/144,1/18,1/6),c(-5/24,1/6,-19/144,-5/72),c(-5/72,-19/144,1/6,-5/24),c(1/6,1/18,-13/144,1/9))
    tab[,,4]=rbind(c(1/288,-1/288,1/144,-1/48),c(-1/48,1/96,-1/72,11/288),c(11/288,-1/72,1/96,-1/48),c(-1/48,1/144,-1/288,1/288))
  }
  if (m==5){
    tab[,,1]=rbind(c(1/5,1/5,1/5,1/5,1/5),c(1/5,1/5,1/5,1/5,1/5),c(1/5,1/5,1/5,1/5,1/5),c(1/5,1/5,1/5,1/5,1/5),c(1/5,1/5,1/5,1/5,1/5))
    tab[,,2]=rbind(c(379/600,-49/600,-17/75,-23/75,-107/300),c(11/200,17/30,-11/200,-33/200,-137/600),c(-61/600,-1/75,169/300,-1/75,-61/600),c(-137/600,-33/200,-11/200,17/30,11/200),c(-107/300,-23/75,-17/75,-49/600,379/600))
    tab[,,3]=rbind(c(127/800,-263/2400,17/1200,47/400,59/300),c(-761/3600,379/1800,-859/7200,-457/7200,-19/3600),c(-111/800,-31/200,757/3600,-31/200,-111/800),c(-19/3600,-457/7200,-859/7200,379/1800,-761/3600),c(59/300,47/400,17/1200,-263/2400,127/800))
    tab[,,4]=rbind(c(17/1800,-31/3600,11/900,-1/100,-13/300),c(-19/450,1/45,-1/40,2/75,73/1800),c(8/225,-109/3600,23/900,-109/3600,8/225),c(73/1800,2/75,-1/40,1/45,-19/450),c(-13/300,-1/100,11/900,-31/3600,17/1800))
    tab[,,5]=rbind(c(1/7200,-1/7200,1/3600,-1/1200,1/300),c(-1/720,1/1800,-1/1440,13/7200,-1/144),c(7/1440,-1/720,1/1200,-1/720,7/1440),c(-1/144,13/7200,-1/1440,1/1800,-1/720),c(1/300,-1/1200,1/3600,-1/7200,1/7200))
  }
  if (m==6){
    tab[,,1]=rbind(c(1/6,1/6,1/6,1/6,1/6,1/6),c(1/6,1/6,1/6,1/6,1/6,1/6),c(1/6,1/6,1/6,1/6,1/6,1/6),c(1/6,1/6,1/6,1/6,1/6,1/6),c(1/6,1/6,1/6,1/6,1/6,1/6),c(1/6,1/6,1/6,1/6,1/6,1/6))
    tab[,,2]=rbind(c(667/1080,-7/216,-361/2160,-35/144,-7/24,-13/40),c(71/720,397/720,-7/360,-133/1080,-133/720,-9/40),c(-1/30,7/180,1183/2160,11/2160,-11/135,-287/2160),c(-287/2160,-11/135,11/2160,1183/2160,7/180,-1/30),c(-9/40,-133/720,-133/1080,-7/360,397/720,71/720),c(-13/40,-7/24,-35/144,-361/2160,-7/216,667/1080))
    tab[,,3]=rbind(c(51413/259200,-30983/259200,-2011/129600,1129/14400,1663/10800,461/2160),c(-52139/259200,63773/259200,-7231/64800,-3389/51840,-113/10800,1607/43200),c(-42767/259200,-4049/25920,31543/129600,-33517/259200,-295/2592,-21469/259200),c(-21469/259200,-295/2592,-33517/259200,31543/129600,-4049/25920,-42767/259200),c(1607/43200,-113/10800,-3389/51840,-7231/64800,63773/259200,-52139/259200),c(461/2160,1663/10800,1129/14400,-2011/129600,-30983/259200,51413/259200))
    tab[,,4]=rbind(c(487/28800,-137/9600,73/4800,-19/43200,-331/10800,-137/2160),c(-15617/259200,8899/259200,-4379/129600,949/51840,269/8100,4103/129600),c(5771/259200,-1481/32400,23/576,-2033/51840,187/8100,13697/259200),c(13697/259200,187/8100,-2033/51840,23/576,-1481/32400,5771/259200),c(4103/129600,269/8100,949/51840,-4379/129600,8899/259200,-15617/259200),c(-137/2160,-331/10800,-19/43200,73/4800,-137/9600,487/28800))
    tab[,,5]=rbind(c(41/86400,-13/28800,11/14400,-67/43200,17/10800,19/2160),c(-989/259200,403/259200,-59/32400,181/51840,-29/6480,-1501/129600),c(2351/259200,-461/129600,11/4800,-823/259200,347/64800,-763/259200),c(-763/259200,347/64800,-823/259200,11/4800,-461/129600,2351/259200),c(-1501/129600,-29/6480,181/51840,-59/32400,403/259200,-989/259200),c(19/2160,17/10800,-67/43200,11/14400,-13/28800,41/86400))
    tab[,,6]=rbind(c(1/259200,-1/259200,1/129600,-1/43200,1/10800,-1/2160),c(-1/17280,1/51840,-1/43200,1/17280,-7/32400,137/129600),c(17/51840,-1/12960,1/25920,-1/17280,1/5400,-1/1152),c(-1/1152,1/5400,-1/17280,1/25920,-1/12960,17/51840),c(137/129600,-7/32400,1/17280,-1/43200,1/51840,-1/17280),c(-1/2160,1/10800,-1/43200,1/129600,-1/259200,1/259200))
    }
  if (m==7){
    tab[,,1]=rbind(c(1/7,1/7,1/7,1/7,1/7,1/7,1/7),c(1/7,1/7,1/7,1/7,1/7,1/7,1/7),c(1/7,1/7,1/7,1/7,1/7,1/7,1/7),c(1/7,1/7,1/7,1/7,1/7,1/7,1/7),c(1/7,1/7,1/7,1/7,1/7,1/7,1/7),c(1/7,1/7,1/7,1/7,1/7,1/7,1/7),c(1/7,1/7,1/7,1/7,1/7,1/7,1/7))
    tab[,,2]=rbind(c(529/882,4/2205,-437/3528,-1151/5880,-713/2940,-809/2940,-293/980),c(221/1764,2351/4410,113/17640,-107/1176,-3/20,-557/2940,-213/980),c(29/2940,209/2940,1166/2205,193/8820,-215/3528,-281/2520,-641/4410),c(-323/4410,-527/17640,743/17640,1168/2205,743/17640,-527/17640,-323/4410),c(-641/4410,-281/2520,-215/3528,193/8820,1166/2205,209/2940,29/2940),c(-213/980,-557/2940,-3/20,-107/1176,113/17640,2351/4410,221/1764),c(-293/980,-809/2940,-713/2940,-1151/5880,-437/3528,4/2205,529/882))
    tab[,,3]=rbind(c(163103/705600,-262159/2116800,-38933/1058400,16901/352800,5237/44100,311/1764,3929/17640),c(-65759/352800,72697/264600,-222569/2116800,-48341/705600,-6523/352800,3223/117600,2593/39200),c(-9139/52920,-314971/2116800,63683/235200,-239119/2116800,-4387/43200,-151427/2116800,-87853/2116800),c(-63211/529200,-284233/2116800,-269987/2116800,17671/66150,-269987/2116800,-284233/2116800,-63211/529200),c(-87853/2116800,-151427/2116800,-4387/43200,-239119/2116800,63683/235200,-314971/2116800,-9139/52920),c(2593/39200,3223/117600,-6523/352800,-48341/705600,-222569/2116800,72697/264600,-65759/352800),c(3929/17640,311/1764,5237/44100,16901/352800,-38933/1058400,-262159/2116800,163103/705600))
    tab[,,4]=rbind(c(319847/12700800,-50509/2540160,104207/6350400,991/141120,-289/15120,-5293/105840,-71/882),c(-37949/508032,58843/1270080,-19211/470400,49337/4233600,59933/2116800,58621/2116800,10361/529200),c(92443/12700800,-745111/12700800,677017/12700800,-590339/12700800,33293/2540160,534701/12700800,12829/235200),c(123481/2540160,17551/1411200,-216679/4233600,176569/3175200,-216679/4233600,17551/1411200,123481/2540160),c(12829/235200,534701/12700800,33293/2540160,-590339/12700800,677017/12700800,-745111/12700800,92443/12700800),c(10361/529200,58621/2116800,59933/2116800,49337/4233600,-19211/470400,58843/1270080,-37949/508032),c(-71/882,-5293/105840,-289/15120,991/141120,104207/6350400,-50509/2540160,319847/12700800))
    tab[,,5]=rbind(c(1433/1411200,-29/31360,319/235200,-17/8640,-17/105840,661/105840,3/196),c(-86999/12700800,2627/907200,-40651/12700800,61169/12700800,-14227/6350400,-58231/6350400,-1783/132300),c(21431/1814400,-26429/4233600,10547/2540160,-65033/12700800,15503/2540160,-4559/4233600,-13289/1270080),c(33743/12700800,105073/12700800,-76331/12700800,229/50400,-76331/12700800,105073/12700800,33743/12700800),c(-13289/1270080,-4559/4233600,15503/2540160,-65033/12700800,10547/2540160,-26429/4233600,21431/1814400),c(-1783/132300,-58231/6350400,-14227/6350400,61169/12700800,-40651/12700800,2627/907200,-86999/12700800),c(3/196,661/105840,-17/105840,-17/8640,319/235200,-29/31360,1433/1411200))
    tab[,,6]=rbind(c(67/4233600,-13/846720,59/2116800,-29/423360,19/105840,-23/105840,-13/8820),c(-2531/12700800,17/254016,-991/12700800,2141/12700800,-2767/6350400,4097/6350400,1259/529200),c(2209/2540160,-1007/4233600,1591/12700800,-2213/12700800,1067/2540160,-383/470400,-193/907200),c(-17509/12700800,1039/1814400,-607/2540160,157/1058400,-607/2540160,1039/1814400,-17509/12700800),c(-193/907200,-383/470400,1067/2540160,-2213/12700800,1591/12700800,-1007/4233600,2209/2540160),c(1259/529200,4097/6350400,-2767/6350400,2141/12700800,-991/12700800,17/254016,-2531/12700800),c(-13/8820,-23/105840,19/105840,-29/423360,59/2116800,-13/846720,67/4233600))
    tab[,,7]=rbind(c(1/12700800,-1/12700800,1/6350400,-1/2116800,1/529200,-1/105840,1/17640),c(-1/604800,1/2116800,-1/1814400,17/12700800,-31/6350400,149/6350400,-1/7200),c(1/72576,-1/362880,1/846720,-1/604800,1/201600,-281/12700800,29/226800),c(-1/17280,19/1814400,-1/362880,1/635040,-1/362880,19/1814400,-1/17280),c(29/226800,-281/12700800,1/201600,-1/604800,1/846720,-1/362880,1/72576),c(-1/7200,149/6350400,-31/6350400,17/12700800,-1/1814400,1/2116800,-1/604800),c(1/17640,-1/105840,1/529200,-1/2116800,1/6350400,-1/12700800,1/12700800))
  }
  if (m==8){
    tab[,,1]=rbind(c(1/8,1/8,1/8,1/8,1/8,1/8,1/8,1/8),c(1/8,1/8,1/8,1/8,1/8,1/8,1/8,1/8),c(1/8,1/8,1/8,1/8,1/8,1/8,1/8,1/8),c(1/8,1/8,1/8,1/8,1/8,1/8,1/8,1/8),c(1/8,1/8,1/8,1/8,1/8,1/8,1/8,1/8),c(1/8,1/8,1/8,1/8,1/8,1/8,1/8,1/8),c(1/8,1/8,1/8,1/8,1/8,1/8,1/8,1/8),c(1/8,1/8,1/8,1/8,1/8,1/8,1/8,1/8))
    tab[,,2]=rbind(c(46847/80640,61/2304,-7363/80640,-857/5376,-183/896,-151/640,-83/320,-621/2240),c(2867/20160,20737/40320,103/4032,-887/13440,-3287/26880,-719/4480,-421/2240,-2801/13440),c(223/5760,1853/20160,2281/4480,143/4032,-497/11520,-29/315,-5059/40320,-1507/10080),c(-337/10080,167/40320,1331/20160,41189/80640,1969/40320,-241/11520,-1033/16128,-7523/80640),c(-7523/80640,-1033/16128,-241/11520,1969/40320,41189/80640,1331/20160,167/40320,-337/10080),c(-1507/10080,-5059/40320,-29/315,-497/11520,143/4032,2281/4480,1853/20160,223/5760),c(-2801/13440,-421/2240,-719/4480,-3287/26880,-887/13440,103/4032,20737/40320,2867/20160),c(-621/2240,-83/320,-151/640,-183/896,-857/5376,-7363/80640,61/2304,46847/80640))
    tab[,,3]=rbind(c(17506193/67737600,-8447843/67737600,-882323/16934400,45317/1881600,507971/5644800,163573/1128960,21475/112896,18353/80640),c(-11548657/67737600,5047349/16934400,-6712847/67737600,-4821647/67737600,-661/25088,10553/627200,12827/235200,54197/627200),c(-11635229/67737600,-233903/1693440,473341/1612800,-3410417/33868800,-6383177/67737600,-10093/151200,-158413/4233600,-184861/16934400),c(-9251699/67737600,-9544589/67737600,-8158961/67737600,3891973/13547520,-819619/7526400,-3955831/33868800,-1721353/16934400,-17503/211680),c(-17503/211680,-1721353/16934400,-3955831/33868800,-819619/7526400,3891973/13547520,-8158961/67737600,-9544589/67737600,-9251699/67737600),c(-184861/16934400,-158413/4233600,-10093/151200,-6383177/67737600,-3410417/33868800,473341/1612800,-233903/1693440,-11635229/67737600),c(54197/627200,12827/235200,10553/627200,-661/25088,-4821647/67737600,-6712847/67737600,5047349/16934400,-11548657/67737600),c(18353/80640,21475/112896,163573/1128960,507971/5644800,45317/1881600,-882323/16934400,-8447843/67737600,17506193/67737600))
    tab[,,4]=rbind(c(366661/10838016,-758431/30105600,739091/45158400,189037/15052800,-11779/1254400,-28351/752640,-8399/125440,-15289/161280),c(-17495893/203212800,47135581/812851200,-18921347/406425600,4929857/812851200,1664437/67737600,3450997/135475200,1223423/67737600,10813/1505280),c(-2748883/406425600,-28078793/406425600,53498239/812851200,-10629557/203212800,1013629/203212800,9158533/270950400,6254159/135475200,105533/2116800),c(1588373/40642560,107129/203212800,-12406927/203212800,56509741/812851200,-2845271/50803200,388253/101606400,79823/2073600,46907171/812851200),c(46907171/812851200,79823/2073600,388253/101606400,-2845271/50803200,56509741/812851200,-12406927/203212800,107129/203212800,1588373/40642560),c(105533/2116800,6254159/135475200,9158533/270950400,1013629/203212800,-10629557/203212800,53498239/812851200,-28078793/406425600,-2748883/406425600),c(10813/1505280,1223423/67737600,3450997/135475200,1664437/67737600,4929857/812851200,-18921347/406425600,47135581/812851200,-17495893/203212800),c(-15289/161280,-8399/125440,-28351/752640,-11779/1254400,189037/15052800,739091/45158400,-758431/30105600,366661/10838016))
    tab[,,5]=rbind(c(710449/406425600,-155623/101606400,80483/40642560,-47429/22579200,-3859/2419200,2501/677376,685/56448,179/8064),c(-1035371/101606400,609631/135475200,-1918663/406425600,2353697/406425600,-899/2822400,-159883/22579200,-193363/16934400,-18841/1411200),c(1347851/101606400,-3744953/406425600,2551259/406425600,-361507/50803200,1361537/203212800,49799/58060800,-812699/101606400,-3202991/203212800),c(510847/67737600,1027969/101606400,-405991/45158400,576299/81285120,-21467/2540160,1622597/203212800,173273/50803200,-738287/135475200),c(-738287/135475200,173273/50803200,1622597/203212800,-21467/2540160,576299/81285120,-405991/45158400,1027969/101606400,510847/67737600),c(-3202991/203212800,-812699/101606400,49799/58060800,1361537/203212800,-361507/50803200,2551259/406425600,-3744953/406425600,1347851/101606400),c(-18841/1411200,-193363/16934400,-159883/22579200,-899/2822400,2353697/406425600,-1918663/406425600,609631/135475200,-1035371/101606400),c(179/8064,685/56448,2501/677376,-3859/2419200,-47429/22579200,80483/40642560,-155623/101606400,710449/406425600))
    tab[,,6]=rbind(c(1331/33868800,-5027/135475200,419/6773760,-619/4838400,979/4233600,19/423360,-593/564480,-239/80640),c(-1087/2540160,29791/203212800,-67589/406425600,64439/203212800,-61627/101606400,5693/25401600,62687/33868800,39961/11289600),c(43691/29030400,-65029/135475200,52963/203212800,-8683/25401600,19513/29030400,-1789/2257920,-78599/203212800,82441/67737600),c(-297403/203212800,109973/101606400,-209843/406425600,16459/50803200,-15857/33868800,8549/9676800,-9529/8467200,-293801/203212800),c(-293801/203212800,-9529/8467200,8549/9676800,-15857/33868800,16459/50803200,-209843/406425600,109973/101606400,-297403/203212800),c(82441/67737600,-78599/203212800,-1789/2257920,19513/29030400,-8683/25401600,52963/203212800,-65029/135475200,43691/29030400),c(39961/11289600,62687/33868800,5693/25401600,-61627/101606400,64439/203212800,-67589/406425600,29791/203212800,-1087/2540160),c(-239/80640,-593/564480,19/423360,979/4233600,-619/4838400,419/6773760,-5027/135475200,1331/33868800))
    tab[,,7]=rbind(c(17/45158400,-1/2709504,47/67737600,-5/2709504,1/169344,-1/52920,1/37632,17/80640),c(-1387/203212800,53/27095040,-61/27095040,683/135475200,-773/50803200,1979/40642560,-1381/16934400,-2209/5644800),c(9469/203212800,-4099/406425600,611/135475200,-23/3763200,11/691200,-2273/45158400,10931/101606400,1709/13547520),c(-3637/25401600,7397/203212800,-527/45158400,173/27095040,-2047/203212800,1189/40642560,-409/5080320,9139/58060800),c(9139/58060800,-409/5080320,1189/40642560,-2047/203212800,173/27095040,-527/45158400,7397/203212800,-3637/25401600),c(1709/13547520,10931/101606400,-2273/45158400,11/691200,-23/3763200,611/135475200,-4099/406425600,9469/203212800),c(-2209/5644800,-1381/16934400,1979/40642560,-773/50803200,683/135475200,-61/27095040,53/27095040,-1387/203212800),c(17/80640,1/37632,-1/52920,1/169344,-5/2709504,47/67737600,-1/2709504,17/45158400))
    tab[,,8]=rbind(c(1/812851200,-1/812851200,1/406425600,-1/135475200,1/33868800,-1/6773760,1/1128960,-1/161280),c(-1/29030400,1/116121600,-1/101606400,19/812851200,-17/203212800,23/58060800,-157/67737600,121/7526400),c(23/58060800,-1/14515200,1/38707200,-1/29030400,1/10160640,-7/16588800,961/406425600,-67/4147200),c(-1/414720,11/29030400,-1/11612160,1/23224320,-1/14515200,1/4147200,-127/101606400,967/116121600),c(967/116121600,-127/101606400,1/4147200,-1/14515200,1/23224320,-1/11612160,11/29030400,-1/414720),c(-67/4147200,961/406425600,-7/16588800,1/10160640,-1/29030400,1/38707200,-1/14515200,23/58060800),c(121/7526400,-157/67737600,23/58060800,-17/203212800,19/812851200,-1/101606400,1/116121600,-1/29030400),c(-1/161280,1/1128960,-1/6773760,1/33868800,-1/135475200,1/406425600,-1/812851200,1/812851200))
  }
  return(tab)
}
