% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocm.methods.R
\name{vcov.ocm}
\alias{vcov.ocm}
\title{Variance-Covariance Matrix for a Fitted Model Object}
\usage{
\method{vcov}{ocm}(object, ...)
}
\arguments{
\item{object}{an \code{ocm} object}

\item{...}{further arguments to be passed to methods}
}
\value{
Variance-covariance matrix of model parameters
}
\description{
Calculates variance-covariance matrix for a fitted \code{ocm} object
}
\details{
For the generalized logistic g-function, the variance-covariance matrix of model 
parameters includes information on fixed- and random- effect terms and smoothing terms.
}
\examples{
\dontrun{
fit.overall  <- ocm(overall  ~ cycleno + age + bsa + treatment, data=ANZ0001.sub, scale=c(0,100))
vcov(fit.overall)
}
}
\seealso{
\code{\link{ocm}}
}
\author{
Maurizio Manuguerra, Gillian Heller
}
