% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocm.R
\name{ocm}
\alias{ocm}
\title{Ordinal regression for continuous scales}
\usage{
ocm(formula, data = NULL, scale = c(0, 1), weights, link = c("logit"),
  niters = c(500, 500), conv_crit = 0.01, n.int.knots = NULL, order = 4,
  lambdas = NA)
}
\arguments{
\item{formula}{a formula expression as for regression models, of the form 
response ~ predictors. Only fixed effects are supported. 
The model must have an intercept: attempts to remove one will lead to a warning and will be 
ignored.}

\item{data}{an optional data frame in which to interpret the variables occurring in the 
formulas}

\item{scale}{a vector of length 2 with the boundaries of the ordinal scale used. Default is \code{c(0,1)}.}

\item{weights}{optional case weights in fitting. Defaults to 1.}

\item{link}{link function, i.e. the type of location-scale distribution assumed for 
the latent distribution. The default ``logit'' link gives the proportional odds model 
and is the only link function currently supported.}

\item{niters}{a vector of length 2 with the maximimum number of external and internal 
iterations used in the fitting algorithm. The internal algorithm estimates the parameters 
of the model conditional on the current values of \eqn{\lambda}s, the smoothing parameters. 
The external algorithm estimates the values of \eqn{\lambda}s conditional on the current 
estimates of the parameters of the model. Default is \code{c(500,500)}}

\item{conv_crit}{the smoothing parameters \eqn{\lambda}'s convergence criteria for the iterative process. 
Default is \eqn{0.01}}

\item{n.int.knots}{the number of internal knots used to compute the spline bases. The default (NULL) is round((n-1-order)*0.8) if in the interval [8,15], and 8 or 15 otherwise.}

\item{order}{the order of the spline functions. The default is 4 (cubic splines).}

\item{lambdas}{NA (the default) or a vector of length equal to the number of smoothing terms, including the g function and, optionally, the random effect terms and the smooters. If ``lambdas'' is a vector, each element \eqn{\lambda_i} can be a number, in which case the corresponding term is penalized using \eqn{\lambda_i} as smoothing parameter, zero, in which case the corresponding term is unpenalized, or NA, in which case the value of \eqn{\lambda_i} is estimated maximmizing the marginal posterior function.}
}
\value{
an object of type \code{ocm} with the components listed below. Parameter estimates are in \code{coefficients}. 
\item{coefficients}{parameter estimates}
\item{pars_obj}{an object of class \code{ocmpars} carrying the parameter estimates and other properties of the regression terms}
\item{vcov}{variance-covariance matrix}
\item{H}{the Hessian matrix}
\item{logLik}{value of the log-likelihood at the estimated optimum}
\item{penlogLik}{value of the lenalized log-likelihood at the estimated optimum}
\item{v}{vector of continuous scores}
\item{sample.size}{sample size (can differ from the number of observations if the weights are different from 1)}
\item{edf}{estimated degrees of freedom}
\item{df.residual}{the residual degrees of freedom}
\item{nobs}{number of observations}
\item{terms}{model terms}
\item{call}{call to fit the model}
\item{data}{data frame used}
\item{weights}{case weights in fitting}
\item{sorting}{the ordinal score v sorting vector}
\item{link}{link function used}
\item{formula}{formula used}
\item{scale}{the boundaries of the ordinal scale used}
 @references Manuguerra M, Heller GZ (2010). Ordinal Regression Models for Continuous 
 Scales, \emph{The International Journal of Biostatistics}: 6(1), Article 14.
}
\description{
Continuous ordinal regression with logit link using I-splines to model the g function.
}
\details{
Fits a continuous ordinal regression model using penalized maximum likelihood. 
The model can contain fixed effects and optionally mixed effects and smoothers. 
The g function is estimated using monotone increasing I-splines, and the link function is the logit, 
implying the standard logistic distribution for the latent variable. Penalized maximum likelihood 
estimation is performed using the \code{MI} algorithm and the splines smoothing parameters are estimated 
maximizing the marginal posterior (details of the iterative process are printed out during the fit).
}
\examples{
fit.overall  <- ocm(overall  ~ cycleno + age + bsa + treatment, data=ANZ0001.sub, scale=c(0,100))
summary(fit.overall)
\dontrun{
plot(fit.overall)
## Smoothers and complete data set
fit.overall.smooth  <- ocm(overall  ~ age + treatment : s(cycleno), data=ANZ0001, scale=c(0,100))
summary(fit.overall.smooth)
plot(fit.overall.smooth)
}
}
\author{
Maurizio Manuguerra, Gillian Heller
}
\keyword{likelihood,}
\keyword{log-likelihood,}
\keyword{ordinal}
\keyword{regression.}
