% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ord-format.r
\name{format}
\alias{format}
\alias{format.tbl_ord}
\alias{print.tbl_ord}
\title{Format a tbl_ord for printing}
\usage{
\method{format}{tbl_ord}(
  x,
  width = NULL,
  ...,
  n = NULL,
  max_extra_cols = NULL,
  max_footer_lines = NULL
)

\method{print}{tbl_ord}(
  x,
  width = NULL,
  ...,
  n = NULL,
  max_extra_cols = NULL,
  max_footer_lines = NULL
)
}
\arguments{
\item{x}{A \link{tbl_ord}.}

\item{width}{Width of text output to generate. This defaults to \code{NULL}, which
means use the \code{width} \link[pillar:pillar_options]{option}.}

\item{...}{Additional arguments.}

\item{n}{Number of rows to show. If \code{NULL}, the default, will print all rows
if less than the \code{print_max} \link[pillar:pillar_options]{option}.
Otherwise, will print as many rows as specified by the
\code{print_min} \link[pillar:pillar_options]{option}.}

\item{max_extra_cols}{Number of extra columns to print abbreviated information for,
if the width is too small for the entire tibble. If \code{NULL},
the \code{max_extra_cols} \link[pillar:pillar_options]{option} is used.
The previously defined \code{n_extra} argument is soft-deprecated.}

\item{max_footer_lines}{Maximum number of footer lines. If \code{NULL},
the \code{max_footer_lines} \link[pillar:pillar_options]{option} is used.}
}
\value{
The \code{format()} method returns a vector of strings that are more
elegantly printed by the \code{print()} method, which itself returns the tbl_ord
invisibly.
}
\description{
These methods of \code{\link[base:format]{base::format()}} and \code{\link[base:print]{base::print()}} render a
(usually more) tidy readout of a \link{tbl_ord} that is consistent across all
original ordination classes.
}
\details{
The \code{format} and \code{print} methods for class 'tbl_ord' are adapted from those
for class '\link[tibble:tbl_df-class]{tbl_df}' and for class 'tbl_graph' from the
\strong{tidygraph} package.

\strong{Note:} The \code{format()} function is tedius but cannot be easily modularized
without invoking \link{recoverers}, \link{annotation}, and \link{augmentation} multiple
times, thereby significantly reducing performance.
}
