% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinate.r
\name{ordinate}
\alias{ordinate}
\alias{ordinate.default}
\alias{ordinate.array}
\alias{ordinate.table}
\alias{ordinate.data.frame}
\alias{ordinate.dist}
\title{Fit an ordination model to a data object}
\usage{
ordinate(x, model, ...)

\method{ordinate}{default}(x, model, ...)

\method{ordinate}{array}(x, model, ...)

\method{ordinate}{table}(x, model, ...)

\method{ordinate}{data.frame}(x, model, cols, augment, ...)

\method{ordinate}{dist}(x, model, ...)
}
\arguments{
\item{x}{A data object to be passed to the \code{model}, such as an \link{array},
\link{table}, \link{data.frame}, or \link[stats:dist]{stats::dist}.}

\item{model}{An ordination function whose output is coercible to class
'\link{tbl_ord}', or a symbol or character string (handled by \code{\link[=match.fun]{match.fun()}}).
Alternatively, a formula \code{~ fun(., ...)} where \code{fun} is such a function and
other arguments are explicit, which will be evaluated with \code{x} in place of
\code{.}.}

\item{...}{Additional arguments passed to \code{model}.}

\item{cols}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> If \code{x} is a data
frame, columns to pass to \code{model}. If missing, all columns are used.}

\item{augment}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> If \code{x} is a data
frame, columns to augment to the row data of the ordination. If missing,
all columns not included in \code{cols} will be augmented.}
}
\value{
An augmented tbl_ord.
}
\description{
This is a convenience function to fit an ordination model to a
data object, wrap the result as a tbl_ord, and annotate this output with
metadata from the model and possibly from the data.
}
\details{
The default method fits the specified model to the provided data object,
wraps the result as a \link{tbl_ord}, and augments this output with any intrinsic
metadata from the model via \code{\link[=augment_ord]{augment_ord()}}.

The default method is used for most classes, though this may change in
future. The \link{data.frame} method allows the user to specify what columns to
include in the model and what columns with which to annotate the output.
}
\examples{
# LRA of arrest data
ordinate(USArrests, cols = c(Murder, Rape, Assault), lra)

# CMDS of inter-city distance data
ordinate(UScitiesD, cmdscale_ord, k = 3L)

# PCA of iris data
ordinate(iris, princomp, cols = -Species, augment = c(Sepal.Width, Species))
ordinate(iris, cols = 1:4, ~ prcomp(., center = TRUE, scale. = TRUE))

# CA of hair & eye color data
haireye <- as.data.frame(rowSums(HairEyeColor, dims = 2L))
ordinate(haireye, MASS::corresp, cols = everything())

# FA of Swiss social data
ordinate(swiss, model = factanal, factors = 2L, scores = "Bartlett")

# LDA of iris data
ordinate(iris, ~ lda_ord(.[, 1:4], .[, 5], ret.x = TRUE))

# CCA of savings data
ordinate(
  LifeCycleSavings[, c("pop15", "pop75")],
  # second data set must be handled as an additional parameter to `model`
  y = LifeCycleSavings[, c("sr", "dpi", "ddpi")],
  model = cancor_ord, scores = TRUE
)
}
