% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.R
\name{ore_ismatch}
\alias{ore_ismatch}
\alias{ore.ismatch}
\alias{\%~\%}
\alias{\%~~\%}
\alias{\%~|\%}
\title{Does text match a regex?}
\usage{
ore_ismatch(regex, text, keepNA = getOption("ore.keepNA", FALSE), ...)

X \%~\% Y

X \%~~\% Y

X \%~|\% Y
}
\arguments{
\item{regex}{A single character string or object of class \code{"ore"}.}

\item{text}{A character vector of strings to search.}

\item{keepNA}{If \code{TRUE}, \code{NA}s will be propagated from \code{text}
into the return value. Otherwise, they evaluate \code{FALSE}.}

\item{...}{Further arguments to \code{\link{ore_search}}.}

\item{X}{A character vector or \code{"ore"} object. See Details.}

\item{Y}{A character vector. See Details.}
}
\value{
A logical vector, indicating whether elements of \code{text} match
  \code{regex}, or not.
}
\description{
These functions test whether the elements of a character vector match a
Oniguruma regular expression. The actual match can be retrieved using
\code{\link{ore_lastmatch}}.
}
\details{
The \code{\%~\%} infix shorthand corresponds to \code{ore_ismatch(..., 
all=FALSE)}, while \code{\%~~\%} corresponds to \code{ore_ismatch(...,
all=TRUE)}. Either way, the first argument can be an \code{"ore"} object,
in which case the second is the text to search, or a character vector, in
which case the second argument is assumed to contain the regex. The
\code{\%~|\%} shorthand returns just those elements of the text vector which
match the regular expression.
}
\examples{
# Test for the presence of a vowel
ore_ismatch("[aeiou]", c("sky","lake"))  # => c(FALSE,TRUE)

# The same thing, in shorter form
c("sky","lake") \%~\% "[aeiou]"

# Same again: the first argument must be an "ore" object this way around
ore("[aeiou]") \%~\% c("sky","lake")
}
\seealso{
\code{\link{ore_search}}
}
