% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orf_user.R
\name{print.orf.prediction}
\alias{print.orf.prediction}
\title{Print of the Ordered Forest Prediction}
\usage{
\method{print}{orf.prediction}(x, ...)
}
\arguments{
\item{x}{predicted Ordered Forest object of class \code{orf.prediction}}

\item{...}{further arguments (currently ignored)}
}
\description{
print of Ordered Forest predictions of class \code{orf.prediction}
}
\details{
\code{print.orf.prediction} provides a first glimpse of the Ordered Forest
prediction, printed directly to the \code{R} console. The printed information
contains the main inputs of the \code{predict.orf} function.
}
\examples{
# Ordered Forest
require(orf)

# load example data
data(odata)

# specify response and covariates for train and test
idx <- sample(seq(1, nrow(odata), 1), 0.8*nrow(odata))

# train set
Y_train <- as.numeric(odata[idx, 1])
X_train <- as.matrix(odata[idx, -1])

# test set
Y_test <- as.numeric(odata[-idx, 1])
X_test <- as.matrix(odata[-idx, -1])

# estimate Ordered Forest
orf_fit <- orf(X_train, Y_train)

# predict the probabilities with the estimated orf
orf_pred <- predict(orf_fit, newdata = X_test)

# print the prediction object
print(orf_pred)

}
\author{
Gabriel Okasa
}
