% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/niftiS4.R
\name{nifti}
\alias{nifti}
\title{Constructor for NIfTI}
\usage{
nifti(img = array(0, dim = rep(1, 4)), dim, datatype = 2, cal.min = NULL,
  cal.max = NULL, pixdim = NULL, ...)
}
\arguments{
\item{img}{is a multidimensional array of data.}

\item{dim}{is the dimension of the data (default = \code{missing}).}

\item{datatype}{is an integer that denotes the type of data contained in
each voxel.  See \code{convert.datatype} or the NIfTI documentation for more
details.}

\item{cal.min}{allows user-specified minimum value in the array
(visualization purposes only).}

\item{cal.max}{allows user-specified minimum value in the array
(visualization purposes only).}

\item{pixdim}{allows user-specified pixel dimension vector (length = 8).}

\item{\dots}{allows for additional \sQuote{slots} to be specified.}
}
\value{
An object of class \code{nifti}.
}
\description{
Constructor for NIfTI class objects.
}
\examples{

options("niftiAuditTrail"=FALSE)

nim <- nifti() # default
nim
nim <- nifti(datatype=4) # 2-byte integers
nim
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\references{
NIfTI-1\cr \url{http://nifti.nimh.nih.gov/}
}
\seealso{
\code{\linkS4class{nifti}}, \code{\link{anlz}},
\code{\link{convert.datatype}}
}

