% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ancillary.R
\name{madRoot}
\alias{madRoot}
\title{Find The Root of a Phylogenetic Tree Using MAD Method}
\usage{
madRoot(tree, output_mode = 'phylo')
}
\arguments{
\item{tree}{unrooted tree string in newick format or a tree object of class 'phylo'.}

\item{output_mode}{amount of information to return. If 'phylo' (default) only the rooted tree is returned. If 'stats' also a structure with the ambiguity index, clock cv, the minimum ancestor deviation and the number of roots. If 'full' also an unrooted tree object, the index of the root branch, the branch ancestor deviations and a rooted tree object.}
}
\value{
a rooted tree and supplementary information if required.
}
\description{
Finds the root of an unrooted phylogenetic tree by minimizing the relative deviation from the molecular clock.
}
\details{
This function is a slight modification of the code provided by Tria et al at https://www.mikrobio.uni-kiel.de/de/ag-dagan/ressourcen.
}
\examples{
# Example 1:
madRoot("(c:1.182246599,b:0.4169984702,a:0.1582465793);")
# Example 2:
\dontrun{
a <- msa(sequences=c("RAPGT", "KMPGT", "ESGGT"), ids = letters[1:3])$ali
tr <- mltree(a)$tree
rtr <- madRoot(tr) }
}
\references{
Tria, F. D. K., Landan, G. and Dagan, T. Nat. Ecol. Evol. 1, 0193 (2017).
}
\author{
Tria, F. D. K., Landan, G. and Dagan, T.
}
