% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hMave.r
\name{hMave}
\alias{hMave}
\title{Hazard Mave for Censored Survival Data}
\usage{
hMave(x, y, censor, m0, B0 = NULL)
}
\arguments{
\item{x}{A matrix for features.}

\item{y}{A vector of observed time.}

\item{censor}{A vector of censoring indicator.}

\item{m0}{number of dimensions to use}

\item{B0}{initial value of B. This is a feature we implemented.}
}
\value{
A list consisting of
\item{B}{The estimated B matrix}
\item{cv}{Leave one out cross-validation error}
}
\description{
This is an almost direct R translation of Xia, Zhang & Xu's (2010) hMave Matlab code. We implemented further options for setting a different initial value. The computational algorithm does not utilize the orthogonality constrained optimization.
}
\examples{
# generate some survival data
set.seed(1)
P = 7
N = 150
dataX = matrix(runif(N*P), N, P)
failEDR = as.matrix(cbind(c(1, 1.3, -1.3, 1, -0.5, 0.5, -0.5, rep(0, P-7))))
T = exp(dataX \%*\% failEDR + rnorm(N))
C = runif(N, 0, 15)
Y = pmin(T, C)
Censor = (T < C)

# fit the model
hMave.fit = hMave(dataX, Y, Censor, 1)
}
\references{
Xia, Y., Zhang, D., & Xu, J. (2010). Dimension reduction and semiparametric estimation of survival models. Journal of the American Statistical Association, 105(489), 278-290.
\url{http://dx.doi.org/10.1198/jasa.2009.tm09372}.
}
