% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectors.R
\name{license_by_keyword}
\alias{license_by_keyword}
\title{Get OSI-listed licenses with a particular keyword}
\usage{
license_by_keyword(keyword, ...)
}
\arguments{
\item{keyword}{The keyword to search for. Acceptable keywords are:
\itemize{
 \item{osi-approved}{ This license has been OSI Approved.}
 \item{redundant}{    This license is redundant with a more widely used license.}
 \item{permissive}{ }
 \item{copyleft}{ This license requires derived works remain Open Source.}
 \item{obsolete}{ This license is considered obsolete by its authors.}
 \item{miscellaneous}{ }
 \item{popular}{ This license is widely used.}
 \item{discouraged}{ This license's use is actively discouraged.}
 \item{non-reusable}{ This license isn't generally usable outside of the authoring organization.}
 \item{special-purpose}{ This license suits a very special purpose.}
 \item{retired}{ This license has been retired by the issuer.}
}}

\item{...}{arguments to pass to httr's GET.}
}
\value{
a list of licenses and their metadata (themselves in the form of
lists) which can be provided to other functions such as \code{\link{license_text}}
}
\description{
\code{license_by_keyword} retrieves a list of
all the metadata associated with OSI-listed licenses that contain
a particular, user-provided keyword.
}
\examples{
# Get copyleft licenses
copyleft_licenses <- license_by_keyword("copyleft")

}
\seealso{
\code{\link{license_text}}, which can consume the results of this
function, as well as
\code{\link{license_by_id}} for an alternate
way of looking up particular licenses.
}

