% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opq.R
\name{opq}
\alias{opq}
\title{Build an Overpass query}
\usage{
opq(bbox = NULL)
}
\arguments{
\item{bbox}{Either (i) four numeric values specifying the maximal and minimal
longitudes and latitudes; (ii) a character string passed to
\link{getbb} to be converted to a numerical bounding box; or
(iii) a matrix representing a bounding polygon as returned from
\code{getbb(..., format_out = "polygon")}.}
}
\value{
An \code{overpass_query} object
}
\description{
Build an Overpass query
}
\examples{
\dontrun{
q <- getbb ("portsmouth", display_name_contains = "United States") \%>\%
            opq () \%>\% 
            add_osm_feature("amenity", "restaurant") \%>\%
            add_osm_feature("amenity", "pub") 
osmdata_sf (q) # all objects that are restaurants AND pubs (there are none!)
q1 <- getbb ("portsmouth", display_name_contains = "United States") \%>\%
                opq () \%>\% 
                add_osm_feature("amenity", "restaurant") 
q2 <- getbb ("portsmouth", display_name_contains = "United States") \%>\%
                opq () \%>\% 
                add_osm_feature("amenity", "pub") 
c (osmdata_sf (q1), osmdata_sf (q2)) # all objects that are restaurants OR pubs
}
}
