% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opq.R
\name{opq_csv}
\alias{opq_csv}
\title{Transform an Overpass query to return the result in a csv format}
\usage{
opq_csv(q, fields, header = TRUE)
}
\arguments{
\item{q}{A opq string or an object of class \code{overpass_query} constructed with
\link{opq} or alternative opq builders (+ \link{add_osm_feature}/s).}

\item{fields}{a character vector with the field names.}

\item{header}{if \code{FALSE}, do not ask for column names.}
}
\value{
The \code{overpass_query} or string with the prefix changed to
return a csv.
}
\description{
Transform an Overpass query to return the result in a csv format
}
\details{
The output format \code{csv}, ask for results in csv. See
\href{https://wiki.openstreetmap.org/wiki/Overpass_API/Overpass_QL#CSV_output_mode}{CSV output mode}
for details. To get the data, use \link{osmdata_data_frame}.
}
\note{
csv queries that reach the timeout will return a 0 row data.frame
without any warning. Increase \code{timeout} in \code{q} if you don't see the
expected result.
}
\examples{
\dontrun{
q <- getbb ("Catalan Countries", format_out = "osm_type_id") \%>\%
    opq (out = "tags center", osm_type = "relation", timeout = 100) \%>\%
    add_osm_feature ("admin_level", "7") \%>\%
    add_osm_feature ("boundary", "administrative") \%>\%
    opq_csv (fields = c("name", "::type", "::id", "::lat", "::lon"))
comarques <- osmdata_data_frame (q) # without timeout parameter, 0 rows

qid<- opq_osm_id (
    type = "relation",
    id = c ("341530", "1809102", "1664395", "343124"),
    out = "tags"
) \%>\%
    opq_csv (fields = c ("name", "name:ca"))
cities <- osmdata_data_frame (qid)
}
}
\seealso{
Other queries: 
\code{\link{add_osm_features}()},
\code{\link{add_osm_feature}()},
\code{\link{bbox_to_string}()},
\code{\link{getbb}()},
\code{\link{opq_around}()},
\code{\link{opq_enclosing}()},
\code{\link{opq_osm_id}()},
\code{\link{opq_string}()},
\code{\link{opq}()},
\code{\link{overpass_status}()}
}
\concept{queries}
