/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose;

import fr.ird.osmose.IMarineOrganism;

public class Prey
implements IMarineOrganism {
    private double biomass;
    private final float trophicLevel;
    private final int index;
    private final float age;
    private final float length;

    Prey(int index, float trophicLevel, float age, float length, double biomass) {
        this.index = index;
        this.trophicLevel = trophicLevel;
        this.biomass = biomass;
        this.age = age;
        this.length = length;
    }

    public double getBiomass() {
        return this.biomass;
    }

    public void incrementBiomass(double biomass) {
        this.biomass += biomass;
    }

    @Override
    public float getTrophicLevel() {
        return this.trophicLevel;
    }

    @Override
    public int getSpeciesIndex() {
        return this.index;
    }

    @Override
    public float getAge() {
        return this.age;
    }

    @Override
    public float getLength() {
        return this.length;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Float.floatToIntBits(this.trophicLevel);
        hash = 97 * hash + this.index;
        hash = 97 * hash + Float.floatToIntBits(this.age);
        hash = 97 * hash + Float.floatToIntBits(this.length);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Prey other = (Prey)obj;
        if (this.trophicLevel != other.trophicLevel) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        if (this.age != other.age) {
            return false;
        }
        return this.length == other.length;
    }

    @Override
    public float getWeight() {
        return 0.0f;
    }
}

