/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.Prey;
import fr.ird.osmose.School;
import fr.ird.osmose.Species;
import fr.ird.osmose.output.AbstractDistribOutput;
import fr.ird.osmose.output.distribution.AbstractDistribution;
import java.io.File;

public class DietDistribOutput
extends AbstractDistribOutput {
    private final Species species;

    public DietDistribOutput(int rank, Species species, AbstractDistribution distrib) {
        super(rank, distrib);
        this.species = species;
        this.getSimulation().requestPreyRecord();
    }

    @Override
    public void reset() {
        this.values = new double[this.getNSpecies() + this.getConfiguration().getNPlankton()][this.getNClass()];
    }

    @Override
    String getFilename() {
        StringBuilder filename = new StringBuilder("Trophic");
        filename.append(File.separatorChar);
        filename.append(this.getConfiguration().getString("output.file.prefix"));
        filename.append("_dietMatrixby");
        filename.append(this.getType().toString());
        filename.append("-");
        filename.append(this.species.getName());
        filename.append("_Simu");
        filename.append(this.getRank());
        filename.append(".csv");
        return filename.toString();
    }

    @Override
    String getDescription() {
        StringBuilder description = new StringBuilder();
        description.append("Distribution of the biomass (tonne) of prey species (in columns) in the diet of ");
        description.append(this.species.getName());
        description.append(" by ");
        description.append(this.getType().getDescription());
        description.append(". For class i, the preyed biomass in [i,i+1[ is reported.");
        return description.toString();
    }

    @Override
    String[] getHeaders() {
        int i;
        String[] headers = new String[this.getNSpecies() + this.getConfiguration().getNPlankton() + 1];
        headers[0] = this.getType().toString();
        for (i = 0; i < this.getNSpecies(); ++i) {
            headers[i + 1] = this.getSimulation().getSpecies(i).getName();
        }
        for (i = 0; i < this.getConfiguration().getNPlankton(); ++i) {
            headers[i + this.getNSpecies() + 1] = this.getSimulation().getPlankton(i).getName();
        }
        return headers;
    }

    @Override
    public void update() {
        for (School predator : this.getSchoolSet().getSchools(this.species, false)) {
            double preyedBiomass = predator.getPreyedBiomass();
            if (!(preyedBiomass > 0.0)) continue;
            for (Prey prey : predator.getPreys()) {
                int classPredator = this.getClass(predator);
                if (classPredator < 0) continue;
                double[] dArray = this.values[prey.getSpeciesIndex()];
                int n = classPredator;
                dArray[n] = dArray[n] + prey.getBiomass();
            }
        }
    }

    @Override
    public void initStep() {
    }
}

