/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output.distribution;

import fr.ird.osmose.Configuration;
import fr.ird.osmose.IMarineOrganism;
import fr.ird.osmose.Osmose;
import fr.ird.osmose.output.distribution.DistributionType;

public abstract class AbstractDistribution {
    float[] classes;
    private final DistributionType type;
    private final int indexSpecies;

    abstract float getDefaultMin();

    abstract float getDefaultMax();

    abstract float getDefaultIncr();

    abstract float getValue(IMarineOrganism var1);

    AbstractDistribution(DistributionType type, int indexSpecies) {
        this.type = type;
        this.indexSpecies = indexSpecies;
    }

    AbstractDistribution(DistributionType type) {
        this(type, -1);
    }

    public final void init() {
        float incr;
        float max;
        float min;
        if (this.indexSpecies >= 0 && this.speciesDistribExist()) {
            min = this.getConfiguration().getFloat(this.getKeyMinSpecies());
            max = this.getConfiguration().getFloat(this.getKeyMaxSpecies());
            incr = this.getConfiguration().getFloat(this.getKeyIncrSpecies());
        } else if (this.distribExist()) {
            min = this.getConfiguration().getFloat(this.getKeyMin());
            max = this.getConfiguration().getFloat(this.getKeyMax());
            incr = this.getConfiguration().getFloat(this.getKeyIncr());
        } else {
            min = this.getDefaultMin();
            max = this.getDefaultMax();
            incr = this.getDefaultIncr();
        }
        int nClass = (int)Math.ceil((max - min) / incr);
        this.classes = new float[nClass];
        this.classes[0] = min;
        for (int i = 1; i < nClass; ++i) {
            this.classes[i] = min + (float)i * incr;
        }
    }

    public int getClass(IMarineOrganism school) {
        return this.getClass(this.getValue(school));
    }

    public final int getClass(float value) {
        int iClass;
        if (value <= this.classes[this.classes.length - 1]) {
            for (iClass = this.classes.length - 1; iClass >= 0 && value < this.classes[iClass]; --iClass) {
            }
        }
        return iClass;
    }

    public float getThreshold(int iClass) {
        return this.classes[iClass];
    }

    public int getNClass() {
        return this.classes.length;
    }

    public DistributionType getType() {
        return this.type;
    }

    private String getKeyMin() {
        return "output.distrib.by" + this.type.toString() + ".min";
    }

    private String getKeyMinSpecies() {
        return this.getKeyMin() + ".sp" + this.indexSpecies;
    }

    private String getKeyMax() {
        return "output.distrib.by" + this.type.toString() + ".max";
    }

    private String getKeyMaxSpecies() {
        return this.getKeyMax() + ".sp" + this.indexSpecies;
    }

    private String getKeyIncr() {
        return "output.distrib.by" + this.type.toString() + ".incr";
    }

    private String getKeyIncrSpecies() {
        return this.getKeyIncr() + ".sp" + this.indexSpecies;
    }

    private boolean speciesDistribExist() {
        return !this.getConfiguration().isNull(this.getKeyMinSpecies()) && !this.getConfiguration().isNull(this.getKeyMaxSpecies()) && !this.getConfiguration().isNull(this.getKeyIncrSpecies());
    }

    private boolean distribExist() {
        return !this.getConfiguration().isNull(this.getKeyMin()) && !this.getConfiguration().isNull(this.getKeyMax()) && !this.getConfiguration().isNull(this.getKeyIncr());
    }

    Configuration getConfiguration() {
        return Osmose.getInstance().getConfiguration();
    }
}

