/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.nio.ByteBuffer;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;

public enum DataType {
    BOOLEAN("boolean", 1),
    BYTE("byte", 1),
    CHAR("char", 1),
    SHORT("short", 2),
    INT("int", 4),
    LONG("long", 8),
    FLOAT("float", 4),
    DOUBLE("double", 8),
    SEQUENCE("Sequence", 4),
    STRING("String", 4),
    STRUCTURE("Structure", 1),
    ENUM1("enum1", 1),
    ENUM2("enum2", 2),
    ENUM4("enum4", 4),
    OPAQUE("opaque", 1);

    private String niceName;
    private int size;

    private DataType(String s, int size) {
        this.niceName = s;
        this.size = size;
    }

    public String toString() {
        return this.niceName;
    }

    public int getSize() {
        return this.size;
    }

    public Class getClassType() {
        return this.getPrimitiveClassType();
    }

    public Class getPrimitiveClassType() {
        if (this == FLOAT) {
            return Float.TYPE;
        }
        if (this == DOUBLE) {
            return Double.TYPE;
        }
        if (this == SHORT || this == ENUM2) {
            return Short.TYPE;
        }
        if (this == INT || this == ENUM4) {
            return Integer.TYPE;
        }
        if (this == BYTE || this == ENUM1) {
            return Byte.TYPE;
        }
        if (this == CHAR) {
            return Character.TYPE;
        }
        if (this == BOOLEAN) {
            return Boolean.TYPE;
        }
        if (this == LONG) {
            return Long.TYPE;
        }
        if (this == STRING) {
            return String.class;
        }
        if (this == STRUCTURE) {
            return StructureData.class;
        }
        if (this == SEQUENCE) {
            return StructureDataIterator.class;
        }
        if (this == OPAQUE) {
            return ByteBuffer.class;
        }
        return null;
    }

    public boolean isString() {
        return this == STRING || this == CHAR;
    }

    public boolean isNumeric() {
        return this == BYTE || this == FLOAT || this == DOUBLE || this == INT || this == SHORT || this == LONG;
    }

    public boolean isIntegral() {
        return this == BYTE || this == INT || this == SHORT || this == LONG;
    }

    public boolean isFloatingPoint() {
        return this == FLOAT || this == DOUBLE;
    }

    public boolean isEnum() {
        return this == ENUM1 || this == ENUM2 || this == ENUM4;
    }

    public static DataType getType(String name) {
        if (name == null) {
            return null;
        }
        try {
            return DataType.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static DataType getType(Class c) {
        if (c == Float.TYPE || c == Float.class) {
            return FLOAT;
        }
        if (c == Double.TYPE || c == Double.class) {
            return DOUBLE;
        }
        if (c == Short.TYPE || c == Short.class) {
            return SHORT;
        }
        if (c == Integer.TYPE || c == Integer.class) {
            return INT;
        }
        if (c == Byte.TYPE || c == Byte.class) {
            return BYTE;
        }
        if (c == Character.TYPE || c == Character.class) {
            return CHAR;
        }
        if (c == Boolean.TYPE || c == Boolean.class) {
            return BOOLEAN;
        }
        if (c == Long.TYPE || c == Long.class) {
            return LONG;
        }
        if (c == String.class) {
            return STRING;
        }
        if (c == StructureData.class) {
            return STRUCTURE;
        }
        if (c == StructureDataIterator.class) {
            return SEQUENCE;
        }
        if (c == ByteBuffer.class) {
            return OPAQUE;
        }
        return null;
    }

    public static long unsignedIntToLong(int i) {
        return i < 0 ? (long)i + 0x100000000L : (long)i;
    }

    public static int unsignedShortToInt(short s) {
        return s & 0xFFFF;
    }

    public static short unsignedByteToShort(byte b) {
        return (short)(b & 0xFF);
    }
}

