% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/adjust_colours.R
\name{adjust_colours}
\alias{adjust_colours}
\title{adjust_colours}
\usage{
adjust_colours(cols = NULL, adj = 0, plot = FALSE)
}
\arguments{
\item{cols}{A vector of R colours (for allowable formats of which, see
?col2rgb).}

\item{adj}{A number between -1 and 1 determining how much to lighten
(positive values) or darken (negative values) the colours.}

\item{plot}{If true, generates a plot to allow visual comparison of original
and adjusted colours}
}
\value{
Corresponding vector of adjusted colours (as hexadecimal strings)
}
\description{
Adjusts a given colour by lightening or darkening it by the specified amount.
Adjustments are made in RGB space, for limitations of which see ?convertColor
}
\examples{
library (wesanderson)
cols <- adjust_colours (wes_palette ("GrandBudapest"), adj=-0.2, plot=TRUE)
}

