% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error-checks.R
\name{isOfLength}
\alias{isOfLength}
\title{Check if the provided object has \code{nbElements} elements}
\usage{
isOfLength(object, nbElements)
}
\arguments{
\item{object}{An object or a list of objects}

\item{nbElements}{number of elements that are supposed in object}
}
\value{
\code{TRUE} if the object or all objects inside the list have \code{nbElements.}
Only the first level of the given list is considered.
}
\description{
Check if the provided object has \code{nbElements} elements
}
\examples{
df <- data.frame(x = c(1, 2, 3))
isOfLength(df, 1)
isOfLength(df, 3)
}
