% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enum.R
\name{enumGetKey}
\alias{enumGetKey}
\alias{getEnumKey}
\title{Get the key mapped to the given value in an \code{enum}}
\usage{
enumGetKey(enum, value)

getEnumKey(enum, value)
}
\arguments{
\item{enum}{The \code{enum} where the key-value pair is stored}

\item{value}{The value that is mapped to the \code{key}}
}
\value{
Key under which the value is stored. If the value is not in the enum,
\code{NULL} is returned.
}
\description{
Get the key mapped to the given value in an \code{enum}
}
\examples{

Symbol <- enum(c(Diamond = 1, Triangle = 2, Circle = 2))
enumGetKey(Symbol, 1)
}
\seealso{
Other enumeration-helpers: 
\code{\link{enumGetValue}()},
\code{\link{enumHasKey}()},
\code{\link{enumKeys}()},
\code{\link{enumPut}()},
\code{\link{enumRemove}()},
\code{\link{enumValues}()},
\code{\link{enum}()}
}
\concept{enumeration-helpers}
