% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrmViaroute.R
\name{osrmViaroute}
\alias{osrmViaroute}
\title{Get Travel Time and Travel Distance Between Two Points}
\usage{
osrmViaroute(xo, yo, xd, yd)
}
\arguments{
\item{xo}{longitude of the origine point.}

\item{yo}{latitude of the origine point.}

\item{xd}{longitude of the destination point.}

\item{yd}{latitude of the destination point.}
}
\value{
A named numeric vector is return. It contains travel time (in minutes) 
and travel distance (in kilometers).
}
\description{
Build and send an OSRM API query to get travel time and travel distance between two points.
This function interface the \emph{viaroute} OSRM service.
}
\examples{
\dontrun{
# Load data
data("com")
# Time and Distance between 2 points
route <- osrmViaroute(xo = com[1,"lon"], yo = com[1,"lat"], 
                      xd = com[15,"lon"], yd = com[15,"lat"])
# Time travel distance (min)
route[1]
# Travel distance (km)
route[2]
# Mean Speed (km/h)
route[2]/(route[1]/60)
}
}
\seealso{
\link{osrmViarouteGeom}
}

