% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ottr.r
\name{TestCase}
\alias{TestCase}
\title{A test case for Ottr. Contains configurations and code to be executed for the test.}
\description{
A test case for Ottr. Contains configurations and code to be executed for the test.

A test case for Ottr. Contains configurations and code to be executed for the test.
}
\examples{
tc = TestCase$new("q1", {
  testthat::assert_true(q1.ans)
})
env = new.env()
env$q1.ans = TRUE
tc$run(env)
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{TestCase$new()}}
\item \href{#method-run}{\code{TestCase$run()}}
\item \href{#method-to_list}{\code{TestCase$to_list()}}
\item \href{#method-clone}{\code{TestCase$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestCase$new(
  name,
  code,
  points = 1,
  hidden = FALSE,
  success_message = NA,
  failure_message = NA
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the test case}

\item{\code{code}}{The code to be executed as part of the test case}

\item{\code{points}}{The point value of the test case}

\item{\code{hidden}}{Whether the test case is hidden}

\item{\code{success_message}}{A message to show to students if the test passes}

\item{\code{failure_message}}{A message to show to students if the test fails}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run"></a>}}
\if{latex}{\out{\hypertarget{method-run}{}}}
\subsection{Method \code{run()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestCase$run(env)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-to_list"></a>}}
\if{latex}{\out{\hypertarget{method-to_list}{}}}
\subsection{Method \code{to_list()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestCase$to_list()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestCase$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
