% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R, R/brown.R, R/hansen.R
\name{bootstrap}
\alias{bootstrap}
\alias{bootstrap,missing-method}
\alias{bootstrap,ANY-method}
\alias{bootstrap,browntree-method}
\alias{bootstrap,hansentree-method}
\alias{bootstrap-hansentree,}
\title{Bootstrapping for uncertainty quantification}
\usage{
\S4method{bootstrap}{missing}(object, ...)

\S4method{bootstrap}{ANY}(object, ...)

\S4method{bootstrap}{browntree}(object, nboot = 200, seed = NULL, ...)

\S4method{bootstrap}{hansentree}(object, nboot = 200, seed = NULL, ...)
}
\arguments{
\item{object}{A fitted model object.}

\item{...}{Additional arguments are passed to \code{\link[ouch:update]{update}}.}

\item{nboot}{integer; number of bootstrap replicates.}

\item{seed}{integer; setting \code{seed} to a non-\code{NULL} value allows one to fix the random seed (see \code{\link[ouch:simulate]{simulate}}).}
}
\description{
Generic bootstrapping for \pkg{ouch} models.
}
\details{
\code{bootstrap} performs a parametric bootstrap for estimation of confidence intervals.
}
\seealso{
Other methods: 
\code{\link{coef}()},
\code{\link{logLik}},
\code{\link{plot}()},
\code{\link{print}()},
\code{\link{simulate}()},
\code{\link{summary}()},
\code{\link{update}()}
}
\concept{methods}
