% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ouxy.r
\name{OUprior}
\alias{OUprior}
\title{Fit OU model for univariate data}
\usage{
OUprior(tree = tree, trait = trait, model = model)
}
\arguments{
\item{tree}{An ape: tree object stored in phylo format}

\item{trait}{a univaraite trait}

\item{model}{specified model preset "OU".}
}
\value{
MLE parameter estimates \eqn{\alpha, \theta, \sigma^2}.
}
\description{
Fit OU model given tree and trait
}
\details{
Parameter estimates \eqn{\alpha, \theta, \sigma^2} are estimated by BM (when \eqn{\alpha = 0}) or OU model from \code{\link[geiger:fitContinuous]{geiger}} for the next step analysis with function \code{HyperParam} to get the reasonable range of the hyper parameter as well as the ancestral value.
}
\examples{

\donttest{
library(ape)
tree<-rcoal(3)
trait<-rnorm(3)
names(trait)<-tree$tip.label
model <- "OU"
OUprior(tree=tree,trait=trait,model=model)
}

}
\references{
\enumerate{
  \item Jhwueng, D-C. (2019) Statistical modeling for adaptive trait evolution. Under review.
  \item Jhwueng, D-C., and Vasileios Maroulas. "Adaptive trait evolution in random environment." Journal of Applied Statistics 43.12 (2016): 2310-2324.
  \item Hansen, Thomas F., Jason Pienaar, and Steven Hecht Orzack. "A comparative method for studying adaptation to a randomly evolving environment." Evolution: International Journal of Organic Evolution 62.8 (2008): 1965-1977.
}
}
